/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Arrays;
import java.util.List;
import net.thisptr.jackson.jq.internal.misc.Strings;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionProcessingException;
import org.apache.druid.math.expr.ExpressionValidationException;
import org.apache.druid.math.expr.LambdaExpr;

public interface NamedFunction {
    public String name();

    default public ExpressionValidationException validationFailed(String reasonFormat, Object ... args) {
        throw new ExpressionValidationException(this, reasonFormat, args);
    }

    default public ExpressionValidationException validationFailed(Throwable e, String reasonFormat, Object ... args) {
        throw new ExpressionValidationException(this, e, reasonFormat, args);
    }

    default public ExpressionProcessingException processingFailed(Throwable e, String reasonFormat, Object ... args) {
        throw new ExpressionProcessingException(this, e, reasonFormat, args);
    }

    default public void validationHelperCheckArgumentCount(List<Expr> args, int count) {
        if (args.size() != count) {
            if (count == 0) {
                throw this.validationFailed("does not accept arguments", new Object[0]);
            }
            if (count == 1) {
                throw this.validationFailed("requires 1 argument", new Object[0]);
            }
            throw this.validationFailed("requires %d arguments", count);
        }
    }

    default public void validationHelperCheckMinArgumentCount(List<Expr> args, int count) {
        if (args.size() < count) {
            if (count == 1) {
                throw this.validationFailed("requires at least 1 argument", new Object[0]);
            }
            throw this.validationFailed("requires at least %d arguments", count);
        }
    }

    default public void validationHelperCheckArgumentRange(List<Expr> args, int start, int end) {
        if (args.size() < start || args.size() > end) {
            throw this.validationFailed("requires %d to %d arguments", start, end);
        }
    }

    default public void validationHelperCheckAnyOfArgumentCount(List<Expr> args, int ... counts) {
        boolean satisfied = false;
        for (int count : counts) {
            if (args.size() != count) continue;
            satisfied = true;
            break;
        }
        if (!satisfied) {
            throw this.validationFailed("requires %s arguments", Strings.join((String)" or ", () -> Arrays.stream(counts).mapToObj(String::valueOf).iterator()));
        }
    }

    default public void validationHelperCheckArgIsLiteral(Expr arg, String argName) {
        if (!arg.isLiteral()) {
            throw this.validationFailed("%s argument must be a literal", argName);
        }
    }

    default public void validationHelperCheckArgumentCount(LambdaExpr lambdaExpr, List<Expr> args, int count) {
        if (args.size() != count) {
            throw this.validationFailed("requires %s arguments", count + 1);
        }
        this.validationHelperCheckLambaArgumentCount(lambdaExpr, args);
    }

    default public void validationHelperCheckMinArgumentCount(LambdaExpr lambdaExpr, List<Expr> args, int count) {
        if (args.size() < count) {
            throw this.validationFailed("requires at least %d arguments", count + 1);
        }
        this.validationHelperCheckLambaArgumentCount(lambdaExpr, args);
    }

    default public void validationHelperCheckLambaArgumentCount(LambdaExpr lambdaExpr, List<Expr> args) {
        if (args.size() != lambdaExpr.identifierCount()) {
            throw this.validationFailed("lambda expression argument count of %d does not match the %d arguments passed to it", lambdaExpr.identifierCount(), args.size());
        }
    }
}

