/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import java.util.Arrays;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.BaseExprEvalVector;

public final class ExprEvalDoubleVector
extends BaseExprEvalVector<double[]> {
    public ExprEvalDoubleVector(double[] values, boolean[] nulls) {
        super(values, nulls);
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.DOUBLE;
    }

    @Override
    public double[] values() {
        return (double[])this.values;
    }

    @Override
    public long[] getLongVector() {
        return Arrays.stream((double[])this.values).mapToLong(d -> (long)d).toArray();
    }

    @Override
    public double[] getDoubleVector() {
        return (double[])this.values;
    }

    @Override
    public Object[] getObjectVector() {
        Object[] objects = new Double[((double[])this.values).length];
        if (this.nulls != null) {
            for (int i = 0; i < ((double[])this.values).length; ++i) {
                objects[i] = this.nulls[i] ? null : Double.valueOf(((double[])this.values)[i]);
            }
        } else {
            for (int i = 0; i < ((double[])this.values).length; ++i) {
                objects[i] = ((double[])this.values)[i];
            }
        }
        return objects;
    }
}

