/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import org.apache.druid.error.DruidException;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.ResultSerializationMode;
import org.apache.druid.query.context.ResponseContext;

public class ToolChestBasedResultSerializedRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> runner;
    private final QueryToolChest<T, Query<T>> toolChest;

    public ToolChestBasedResultSerializedRunner(Query<T> query, QuerySegmentWalker walker, QueryToolChest<T, Query<T>> toolChest) {
        this.runner = query.getRunner(walker);
        this.toolChest = toolChest;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        Sequence<Object> resultSeq;
        Query<T> query = queryPlus.getQuery();
        Sequence<T> seq = this.runner.run(queryPlus, responseContext);
        boolean useNestedForUnknownTypeInSubquery = query.context().isUseNestedForUnknownTypeInSubquery();
        ResultSerializationMode serializationMode = this.getResultSerializationMode(query);
        switch (serializationMode) {
            case ROWS: {
                resultSeq = this.toolChest.resultsAsArrays(query, seq);
                break;
            }
            case FRAMES: {
                resultSeq = this.toolChest.resultsAsFrames(query, seq, ArenaMemoryAllocatorFactory.makeDefault(), useNestedForUnknownTypeInSubquery).orElseThrow(() -> DruidException.defensive("Unable to materialize the results as frames.", new Object[0]));
                break;
            }
            default: {
                throw DruidException.defensive("Not supported serializationMode [%s].", new Object[]{serializationMode});
            }
        }
        return resultSeq;
    }

    private ResultSerializationMode getResultSerializationMode(Query<T> query) {
        ResultSerializationMode serializationMode = query.context().getEnum("serialization", ResultSerializationMode.class, null);
        if (serializationMode == null) {
            throw DruidException.defensive("Serialization mode [%s] is not setup correctly!", "serialization");
        }
        return serializationMode;
    }
}

