/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.join.JoinPrefixUtils;
import org.joda.time.Interval;

public class DataSourceAnalysis {
    private final DataSource baseDataSource;
    @Nullable
    private final Query<?> baseQuery;
    @Nullable
    private final DimFilter joinBaseTableFilter;
    private final List<PreJoinableClause> preJoinableClauses;
    @Nullable
    private final QuerySegmentSpec querySegmentSpec;

    public DataSourceAnalysis(DataSource baseDataSource, @Nullable Query<?> baseQuery, @Nullable DimFilter joinBaseTableFilter, List<PreJoinableClause> preJoinableClauses, @Nullable QuerySegmentSpec querySegmentSpec) {
        if (baseDataSource instanceof JoinDataSource) {
            throw new IAE("Base dataSource cannot be a join! Original base datasource was: %s", baseDataSource);
        }
        this.baseDataSource = baseDataSource;
        this.baseQuery = baseQuery;
        this.joinBaseTableFilter = joinBaseTableFilter;
        this.preJoinableClauses = preJoinableClauses;
        this.querySegmentSpec = querySegmentSpec;
    }

    public DataSource getBaseDataSource() {
        return this.baseDataSource;
    }

    public TableDataSource getBaseTableDataSource() {
        if (this.baseDataSource instanceof TableDataSource) {
            return (TableDataSource)this.baseDataSource;
        }
        throw DruidException.defensive("Base dataSource[%s] is not a table!", this.baseDataSource);
    }

    public Optional<UnionDataSource> getBaseUnionDataSource() {
        if (this.baseDataSource instanceof UnionDataSource) {
            return Optional.of((UnionDataSource)this.baseDataSource);
        }
        return Optional.empty();
    }

    public Optional<Query<?>> getBaseQuery() {
        return Optional.ofNullable(this.baseQuery);
    }

    public Optional<DimFilter> getJoinBaseTableFilter() {
        return Optional.ofNullable(this.joinBaseTableFilter);
    }

    public QuerySegmentSpec getEffectiveQuerySegmentSpec() {
        if (this.querySegmentSpec == null) {
            throw DruidException.defensive("Can't answer this question. Please obtain a datasource analysis from the Query object!", new Object[0]);
        }
        return this.querySegmentSpec;
    }

    public List<PreJoinableClause> getPreJoinableClauses() {
        return this.preJoinableClauses;
    }

    public boolean isConcreteBased() {
        return this.baseDataSource.isConcrete() && this.preJoinableClauses.stream().allMatch(clause -> clause.getDataSource().isGlobal());
    }

    public boolean isTableBased() {
        return this.baseDataSource instanceof TableDataSource || this.baseDataSource instanceof RestrictedDataSource || this.baseDataSource instanceof UnionDataSource && this.baseDataSource.getChildren().stream().allMatch(ds -> ds instanceof TableDataSource) || this.baseDataSource instanceof UnnestDataSource && this.baseDataSource.getChildren().stream().allMatch(ds -> ds instanceof TableDataSource);
    }

    public boolean isConcreteAndTableBased() {
        return this.isConcreteBased() && this.isTableBased();
    }

    public boolean isJoin() {
        return !this.preJoinableClauses.isEmpty();
    }

    public boolean isBaseColumn(String column) {
        if (this.baseQuery != null) {
            return false;
        }
        for (PreJoinableClause clause : this.preJoinableClauses) {
            if (!JoinPrefixUtils.isPrefixedBy(column, clause.getPrefix())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceAnalysis that = (DataSourceAnalysis)o;
        return Objects.equals(this.baseDataSource, that.baseDataSource) && Objects.equals(this.querySegmentSpec, that.querySegmentSpec);
    }

    public int hashCode() {
        return Objects.hash(this.baseDataSource, this.querySegmentSpec);
    }

    public String toString() {
        return "DataSourceAnalysis{, baseDataSource=" + String.valueOf(this.baseDataSource) + ", baseQuery=" + String.valueOf(this.baseQuery) + ", preJoinableClauses=" + String.valueOf(this.preJoinableClauses) + "}";
    }

    public boolean isGlobal() {
        for (PreJoinableClause preJoinableClause : this.preJoinableClauses) {
            if (preJoinableClause.getDataSource().isGlobal()) continue;
            return false;
        }
        return this.baseDataSource.isGlobal();
    }

    public DataSourceAnalysis maybeWithQuerySegmentSpec(QuerySegmentSpec newQuerySegmentSpec) {
        if (newQuerySegmentSpec == null) {
            newQuerySegmentSpec = new MultipleIntervalSegmentSpec((List<Interval>)Intervals.ONLY_ETERNITY);
        }
        if (this.querySegmentSpec == null) {
            return new DataSourceAnalysis(this.baseDataSource, this.baseQuery, this.joinBaseTableFilter, this.preJoinableClauses, newQuerySegmentSpec);
        }
        return this;
    }
}

