/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.query.rowsandcols.LimitedRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;

public class DefaultClusteredGroupPartitioner
implements ClusteredGroupPartitioner {
    private final RowsAndColumns rac;

    public DefaultClusteredGroupPartitioner(RowsAndColumns rac) {
        this.rac = rac;
    }

    @Override
    public int[] computeBoundaries(List<String> columns) {
        if (this.rac.numRows() == 0) {
            return new int[0];
        }
        IntArrayList boundaries = new IntArrayList(new int[]{0, this.rac.numRows()});
        for (String column : columns) {
            Column theCol = this.rac.findColumn(column);
            if (theCol == null) continue;
            ColumnAccessor accessor = theCol.toAccessor();
            IntArrayList newBoundaries = new IntArrayList();
            newBoundaries.add(0);
            for (int i = 1; i < boundaries.size(); ++i) {
                int start = boundaries.getInt(i - 1);
                int end = boundaries.getInt(i);
                for (int j = start + 1; j < end; ++j) {
                    int comparison = accessor.compareRows(j - 1, j);
                    if (comparison == 0) continue;
                    newBoundaries.add(j);
                }
                newBoundaries.add(end);
            }
            boundaries = newBoundaries;
        }
        return boundaries.toIntArray();
    }

    @Override
    public ArrayList<RowsAndColumns> partitionOnBoundaries(List<String> partitionColumns) {
        int[] boundaries = this.computeBoundaries(partitionColumns);
        if (boundaries.length < 2) {
            return new ArrayList<RowsAndColumns>();
        }
        ArrayList<RowsAndColumns> retVal = new ArrayList<RowsAndColumns>(boundaries.length - 1);
        for (int i = 1; i < boundaries.length; ++i) {
            int start = boundaries[i - 1];
            int end = boundaries[i];
            retVal.add(new LimitedRowsAndColumns(this.rac, start, end));
        }
        return retVal;
    }
}

