/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import java.nio.ByteBuffer;
import org.apache.druid.query.CursorGranularizer;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.topn.Generic1AggPooledTopNScanner;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;

public final class Generic1AggPooledTopNScannerPrototype
implements Generic1AggPooledTopNScanner {
    @Override
    public long scanAndAggregate(DimensionSelector dimensionSelector, BufferAggregator aggregator, int aggregatorSize, Cursor cursor, CursorGranularizer granularizer, int[] positions, ByteBuffer resultsBuffer) {
        long processedRows = 0L;
        int positionToAllocate = 0;
        if (granularizer.currentOffsetWithinBucket()) {
            while (!cursor.isDoneOrInterrupted()) {
                IndexedInts dimValues = dimensionSelector.getRow();
                int dimSize = dimValues.size();
                for (int i = 0; i < dimSize; ++i) {
                    int dimIndex = dimValues.get(i);
                    int position = positions[dimIndex];
                    if (position >= 0) {
                        aggregator.aggregate(resultsBuffer, position);
                        continue;
                    }
                    if (position != -1) continue;
                    positions[dimIndex] = positionToAllocate;
                    position = positionToAllocate;
                    aggregator.init(resultsBuffer, position);
                    aggregator.aggregate(resultsBuffer, position);
                    positionToAllocate += aggregatorSize;
                }
                ++processedRows;
                if (granularizer.advanceCursorWithinBucketUninterruptedly()) continue;
                break;
            }
        }
        return processedRows;
    }
}

