/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.IOException;
import java.io.UncheckedIOException;
import javax.annotation.Nullable;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;

public class QueryableIndexPhysicalSegmentInspector
implements PhysicalSegmentInspector {
    private final QueryableIndex index;

    public QueryableIndexPhysicalSegmentInspector(QueryableIndex index) {
        this.index = index;
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    @Override
    @Nullable
    public Comparable getMinValue(String dimension) {
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder != null && columnHolder.getCapabilities().hasBitmapIndexes()) {
            ColumnIndexSupplier indexSupplier = columnHolder.getIndexSupplier();
            DictionaryEncodedStringValueIndex index = indexSupplier.as(DictionaryEncodedStringValueIndex.class);
            return index.getCardinality() > 0 ? (Comparable)index.getValue(0) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String dimension) {
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder != null && columnHolder.getCapabilities().hasBitmapIndexes()) {
            ColumnIndexSupplier indexSupplier = columnHolder.getIndexSupplier();
            DictionaryEncodedStringValueIndex index = indexSupplier.as(DictionaryEncodedStringValueIndex.class);
            return index.getCardinality() > 0 ? (Comparable)index.getValue(index.getCardinality() - 1) : null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDimensionCardinality(String column) {
        ColumnHolder columnHolder = this.index.getColumnHolder(column);
        if (columnHolder == null) {
            return 1;
        }
        try (BaseColumn col = columnHolder.getColumn();){
            if (!(col instanceof DictionaryEncodedColumn)) {
                int n2 = -1;
                return n2;
            }
            int n = ((DictionaryEncodedColumn)col).getCardinality();
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.index.getColumnCapabilities(column);
    }

    @Override
    public int getNumRows() {
        return this.index.getNumRows();
    }
}

