/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.core.JsonProcessingException;
import it.unimi.dsi.fastutil.Hash;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.apache.druid.segment.NestedDataColumnSchema;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ObjectStrategyComplexTypeStrategy;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.nested.NestedDataColumnSupplierV4;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.serde.ColumnSerializerUtils;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class NestedDataComplexTypeSerde
extends ComplexMetricSerde {
    public static final String TYPE_NAME = "json";
    public static final NestedDataComplexTypeSerde INSTANCE = new NestedDataComplexTypeSerde();

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public ComplexMetricExtractor getExtractor() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
        NestedDataColumnSupplierV4 supplier = NestedDataColumnSupplierV4.read(buffer, builder, columnConfig, ColumnSerializerUtils.SMILE_MAPPER);
        ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
        capabilitiesBuilder.setDictionaryEncoded(true);
        capabilitiesBuilder.setDictionaryValuesSorted(true);
        capabilitiesBuilder.setDictionaryValuesUnique(true);
        ColumnType simpleType = supplier.getSimpleType();
        if (simpleType != null) {
            builder.setType(simpleType);
        } else {
            builder.setComplexTypeName(TYPE_NAME);
        }
        builder.setComplexColumnSupplier(supplier);
        builder.setColumnFormat(new NestedColumnFormatV4());
    }

    @Override
    public ObjectStrategy getObjectStrategy() {
        return new ObjectStrategy<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return Comparators.naturalNullsFirst().compare((Object)StructuredData.wrap(o1), (Object)StructuredData.wrap(o2));
            }

            @Override
            public Class<? extends Object> getClazz() {
                return StructuredData.class;
            }

            @Override
            @Nullable
            public Object fromByteBuffer(ByteBuffer buffer, int numBytes) {
                return NestedDataComplexTypeSerde.deserializeBuffer(buffer, numBytes);
            }

            @Override
            @Nullable
            public byte[] toBytes(@Nullable Object val) {
                return NestedDataComplexTypeSerde.serializeToBytes(val);
            }

            @Override
            public boolean readRetainsBufferReference() {
                return false;
            }
        };
    }

    public static StructuredData deserializeBuffer(ByteBuffer buf) {
        return NestedDataComplexTypeSerde.deserializeBuffer(buf, buf.remaining());
    }

    public static StructuredData deserializeBuffer(ByteBuffer buf, int numBytes) {
        if (numBytes == 0) {
            return null;
        }
        byte[] bytes = new byte[numBytes];
        buf.get(bytes, 0, numBytes);
        return NestedDataComplexTypeSerde.deserializeBytes(bytes);
    }

    public static StructuredData deserializeBytes(byte[] bytes) {
        return NestedDataComplexTypeSerde.deserializeBytes(bytes, 0, bytes.length);
    }

    public static StructuredData deserializeBytes(byte[] bytes, int offset, int len) {
        if (len == 0) {
            return null;
        }
        try {
            return (StructuredData)ColumnSerializerUtils.SMILE_MAPPER.readValue(bytes, offset, len, StructuredData.class);
        }
        catch (IOException e) {
            throw DruidException.defensive(e, "Unable to deserialize value", new Object[0]);
        }
    }

    public static byte[] serializeToBytes(@Nullable Object val) {
        if (val == null) {
            return new byte[0];
        }
        try {
            return ColumnSerializerUtils.SMILE_MAPPER.writeValueAsBytes(val);
        }
        catch (JsonProcessingException e) {
            throw DruidException.defensive(e, "Unable to serialize value [%s]", val);
        }
    }

    @Override
    public <T extends Comparable<T>> TypeStrategy<T> getTypeStrategy() {
        return new ObjectStrategyComplexTypeStrategy<Object>(this.getObjectStrategy(), ColumnType.ofComplex(TYPE_NAME), new Hash.Strategy<Object>(){

            public int hashCode(Object o) {
                return StructuredData.wrap(o).equalityHash();
            }

            public boolean equals(Object a, Object b) {
                return StructuredData.wrap(a).compareTo(StructuredData.wrap(b)) == 0;
            }
        });
    }

    public static class NestedColumnFormatV4
    implements ColumnFormat {
        @Override
        public ColumnType getLogicalType() {
            return ColumnType.NESTED_DATA;
        }

        @Override
        public DimensionHandler getColumnHandler(String columnName) {
            return new NestedCommonFormatColumnHandler(columnName, null);
        }

        @Override
        public DimensionSchema getColumnSchema(String columnName) {
            return new NestedDataColumnSchema(columnName, 5);
        }

        @Override
        public ColumnFormat merge(@Nullable ColumnFormat otherFormat) {
            return this;
        }

        @Override
        public ColumnCapabilities toColumnCapabilities() {
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.NESTED_DATA).setHasNulls(true);
        }
    }
}

