/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import java.util.HashMap;
import java.util.List;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.collection.MemoryPointer;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.column.RowSignature;

public class ExpressionDeferredGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private final Expr expr;
    private final List<GroupByVectorColumnSelector> subSelectors;
    private final int exprKeyBytes;
    private final ResultRow tmpResultRow;
    private final Expr.ObjectBinding tmpResultRowBindings;

    ExpressionDeferredGroupByVectorColumnSelector(Expr expr, RowSignature exprInputSignature, List<GroupByVectorColumnSelector> subSelectors) {
        this.expr = expr;
        this.subSelectors = subSelectors;
        this.tmpResultRow = ResultRow.create(subSelectors.size());
        int exprKeyBytesTmp = 0;
        HashMap tmpResultRowSuppliers = new HashMap();
        for (int i = 0; i < exprInputSignature.size(); ++i) {
            int columnPosition = i;
            exprKeyBytesTmp += subSelectors.get(i).getGroupingKeySize();
            tmpResultRowSuppliers.put(exprInputSignature.getColumnName(i), InputBindings.inputSupplier(ExpressionType.fromColumnType(exprInputSignature.getColumnType(columnPosition).orElse(null)), () -> this.tmpResultRow.getArray()[columnPosition]));
        }
        this.exprKeyBytes = exprKeyBytesTmp;
        this.tmpResultRowBindings = InputBindings.forInputSuppliers(tmpResultRowSuppliers);
    }

    @Override
    public int getGroupingKeySize() {
        return this.exprKeyBytes;
    }

    @Override
    public int getValueCardinality() {
        if (this.subSelectors.size() == 1) {
            return this.subSelectors.get(0).getValueCardinality();
        }
        return -1;
    }

    @Override
    public int writeKeys(WritableMemory keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        int retVal = 0;
        for (GroupByVectorColumnSelector subSelector : this.subSelectors) {
            retVal += subSelector.writeKeys(keySpace, keySize, keyOffset, startRow, endRow);
            keyOffset += subSelector.getGroupingKeySize();
        }
        return retVal;
    }

    @Override
    public void writeKeyToResultRow(MemoryPointer keyMemory, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        for (int i = 0; i < this.subSelectors.size(); ++i) {
            GroupByVectorColumnSelector subSelector = this.subSelectors.get(i);
            subSelector.writeKeyToResultRow(keyMemory, keyOffset, this.tmpResultRow, i);
            keyOffset += subSelector.getGroupingKeySize();
        }
        resultRow.getArray()[resultRowPosition] = this.expr.eval(this.tmpResultRowBindings).valueOrDefault();
    }

    @Override
    public void reset() {
        for (GroupByVectorColumnSelector subSelector : this.subSelectors) {
            subSelector.reset();
        }
    }
}

