/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.local;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.ExportStorageProvider;
import org.apache.druid.storage.StorageConfig;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.local.LocalFileStorageConnector;

@JsonTypeName(value="local")
public class LocalFileExportStorageProvider
implements ExportStorageProvider {
    public static final String TYPE_NAME = "local";
    @JacksonInject
    StorageConfig storageConfig;
    @JsonProperty
    private final String exportPath;

    @JsonCreator
    public LocalFileExportStorageProvider(@JsonProperty(value="exportPath", required=true) String exportPath) {
        this.exportPath = exportPath;
    }

    @Override
    public StorageConnector createStorageConnector(File taskTempDir) {
        File exportDestination = LocalFileExportStorageProvider.validateAndGetPath(this.storageConfig.getBaseDir(), this.exportPath);
        try {
            return new LocalFileStorageConnector(exportDestination);
        }
        catch (IOException e) {
            throw new IAE(e, "Unable to create storage connector [%s] for base path [%s]", LocalFileStorageConnector.class.getSimpleName(), exportDestination.toPath());
        }
    }

    @Override
    @JsonIgnore
    public String getResourceType() {
        return TYPE_NAME;
    }

    @Override
    @JsonIgnore
    public String getBasePath() {
        return this.exportPath;
    }

    @Override
    public String getFilePathForManifest(String fileName) {
        File exportFile = new File(this.exportPath, fileName);
        return StringUtils.format("file:%s", exportFile.toPath().normalize());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFileExportStorageProvider that = (LocalFileExportStorageProvider)o;
        return Objects.equals(this.exportPath, that.exportPath);
    }

    public int hashCode() {
        return Objects.hash(this.exportPath);
    }

    public String toString() {
        return "LocalFileExportStorageProvider{exportPath=" + this.exportPath + "}";
    }

    public static File validateAndGetPath(String basePath, String customPath) {
        if (basePath == null) {
            throw DruidException.forPersona(DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.NOT_FOUND).build("The runtime property `druid.export.storage.baseDir` must be configured for local export.", new Object[0]);
        }
        File baseDir = new File(basePath);
        if (!baseDir.isAbsolute()) {
            throw DruidException.forPersona(DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.INVALID_INPUT).build("The runtime property `druid.export.storage.baseDir` must be an absolute path.", new Object[0]);
        }
        File exportFile = new File(customPath);
        if (!exportFile.toPath().normalize().startsWith(baseDir.toPath())) {
            throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("The provided destination [%s] must be within the path configured by runtime property `druid.export.storage.baseDir` Please reach out to the cluster admin for the allowed path. ", customPath);
        }
        return exportFile;
    }
}

