/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client.preauth.builtin;

import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.preauth.AbstractPreauthPlugin;
import org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.kerby.kerberos.kerb.preauth.PaFlag;
import org.apache.kerby.kerberos.kerb.preauth.PaFlags;
import org.apache.kerby.kerberos.kerb.preauth.PluginRequestContext;
import org.apache.kerby.kerberos.kerb.preauth.PreauthPluginMeta;
import org.apache.kerby.kerberos.kerb.preauth.builtin.EncTsPreauthMeta;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.pa.PaData;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import org.apache.kerby.kerberos.kerb.type.pa.PaEncTsEnc;

public class EncTsPreauth
extends AbstractPreauthPlugin {
    public EncTsPreauth() {
        super((PreauthPluginMeta)new EncTsPreauthMeta());
    }

    @Override
    public void prepareQuestions(KdcRequest kdcRequest, PluginRequestContext requestContext) throws KrbException {
        kdcRequest.needAsKey();
    }

    @Override
    public void tryFirst(KdcRequest kdcRequest, PluginRequestContext requestContext, PaData outPadata) throws KrbException {
        if (kdcRequest.getAsKey() == null) {
            kdcRequest.needAsKey();
        }
        outPadata.addElement((Asn1Type)this.makeEntry(kdcRequest));
    }

    @Override
    public boolean process(KdcRequest kdcRequest, PluginRequestContext requestContext, PaDataEntry inPadata, PaData outPadata) throws KrbException {
        if (kdcRequest.getAsKey() == null) {
            kdcRequest.needAsKey();
        }
        outPadata.addElement((Asn1Type)this.makeEntry(kdcRequest));
        return true;
    }

    @Override
    public PaFlags getFlags(PaDataType paType) {
        PaFlags paFlags = new PaFlags(0);
        paFlags.setFlag((EnumType)PaFlag.PA_REAL);
        return paFlags;
    }

    private PaDataEntry makeEntry(KdcRequest kdcRequest) throws KrbException {
        PaEncTsEnc paTs = new PaEncTsEnc();
        paTs.setPaTimestamp(kdcRequest.getPreauthTime());
        EncryptedData paDataValue = EncryptionUtil.seal((Asn1Encodeable)paTs, (EncryptionKey)kdcRequest.getAsKey(), (KeyUsage)KeyUsage.AS_REQ_PA_ENC_TS);
        PaDataEntry tsPaEntry = new PaDataEntry();
        tsPaEntry.setPaDataType(PaDataType.ENC_TIMESTAMP);
        tsPaEntry.setPaDataValue(KrbCodec.encode((Asn1Type)paDataValue));
        return tsPaEntry;
    }
}

