/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.discovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.curator.announcement.Announcer;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.ZkPathsConfig;

public class CuratorDruidNodeAnnouncer
implements DruidNodeAnnouncer {
    private static final Logger log = new Logger(CuratorDruidNodeAnnouncer.class);
    private final Announcer announcer;
    private final ZkPathsConfig config;
    private final ObjectMapper jsonMapper;

    static String makeNodeAnnouncementPath(ZkPathsConfig config, NodeRole nodeRole, DruidNode node) {
        return ZKPaths.makePath((String)config.getInternalDiscoveryPath(), (String)nodeRole.toString(), (String[])new String[]{node.getHostAndPortToUse()});
    }

    @Inject
    public CuratorDruidNodeAnnouncer(Announcer announcer, ZkPathsConfig config, @Json ObjectMapper jsonMapper) {
        this.announcer = announcer;
        this.config = config;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public void announce(DiscoveryDruidNode discoveryDruidNode) {
        try {
            String asString = this.jsonMapper.writeValueAsString((Object)discoveryDruidNode);
            log.debug("Announcing self [%s].", new Object[]{asString});
            String path = CuratorDruidNodeAnnouncer.makeNodeAnnouncementPath(this.config, discoveryDruidNode.getNodeRole(), discoveryDruidNode.getDruidNode());
            this.announcer.announce(path, StringUtils.toUtf8((String)asString));
            log.info("Announced self [%s].", new Object[]{asString});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unannounce(DiscoveryDruidNode discoveryDruidNode) {
        try {
            String asString = this.jsonMapper.writeValueAsString((Object)discoveryDruidNode);
            log.debug("Unannouncing self [%s].", new Object[]{asString});
            String path = CuratorDruidNodeAnnouncer.makeNodeAnnouncementPath(this.config, discoveryDruidNode.getNodeRole(), discoveryDruidNode.getDruidNode());
            this.announcer.unannounce(path);
            log.info("Unannounced self [%s].", new Object[]{asString});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

