/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.column.RowSignature;

public class TaskSegmentSchemaUtil {
    public static SchemaPayloadPlus getSegmentSchema(File segmentFile, IndexIO indexIO) throws IOException {
        QueryableIndex queryableIndex = indexIO.loadIndex(segmentFile);
        RowSignature rowSignature = new QueryableIndexCursorFactory(queryableIndex).getRowSignature();
        long numRows = queryableIndex.getNumRows();
        AggregatorFactory[] aggregatorFactories = queryableIndex.getMetadata().getAggregators();
        HashMap<String, AggregatorFactory> aggregatorFactoryMap = new HashMap<String, AggregatorFactory>();
        if (null != aggregatorFactories) {
            for (AggregatorFactory aggregatorFactory : aggregatorFactories) {
                aggregatorFactoryMap.put(aggregatorFactory.getName(), aggregatorFactory);
            }
        }
        return new SchemaPayloadPlus(new SchemaPayload(rowSignature, aggregatorFactoryMap), Long.valueOf(numRows));
    }
}

