/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import java.util.Set;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.SegmentToMoveCalculator;
import org.apache.druid.server.coordinator.balancer.TierSegmentBalancer;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;

public class BalanceSegments
implements CoordinatorDuty {
    private static final Logger log = new Logger(BalanceSegments.class);
    private final Duration coordinatorPeriod;

    public BalanceSegments(Duration coordinatorPeriod) {
        this.coordinatorPeriod = coordinatorPeriod;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        if (params.getUsedSegmentCount() <= 0) {
            return params;
        }
        int maxSegmentsToMove = this.getMaxSegmentsToMove(params);
        params.getCoordinatorStats().add(Stats.Balancer.MAX_TO_MOVE, maxSegmentsToMove);
        if (maxSegmentsToMove <= 0) {
            return params;
        }
        params.getDruidCluster().getHistoricals().forEach((tier, servers) -> new TierSegmentBalancer((String)tier, (Set<ServerHolder>)servers, maxSegmentsToMove, params).run());
        CoordinatorRunStats runStats = params.getCoordinatorStats();
        params.getBalancerStrategy().getStats().forEachStat(runStats::add);
        return params;
    }

    private int getMaxSegmentsToMove(DruidCoordinatorRuntimeParams params) {
        CoordinatorDynamicConfig dynamicConfig = params.getCoordinatorDynamicConfig();
        if (dynamicConfig.isSmartSegmentLoading()) {
            Pair<Integer, Integer> numHistoricalsAndSegments = this.getNumHistoricalsAndSegments(params.getDruidCluster());
            int totalSegmentsInCluster = (Integer)numHistoricalsAndSegments.rhs;
            int numBalancerThreads = params.getSegmentLoadingConfig().getBalancerComputeThreads();
            int maxSegmentsToMove = SegmentToMoveCalculator.computeMaxSegmentsToMovePerTier(totalSegmentsInCluster, numBalancerThreads, this.coordinatorPeriod);
            log.debug("Computed maxSegmentsToMove[%,d] for total [%,d] segments on [%d] historicals.", new Object[]{maxSegmentsToMove, totalSegmentsInCluster, numHistoricalsAndSegments.lhs});
            return maxSegmentsToMove;
        }
        return dynamicConfig.getMaxSegmentsToMove();
    }

    private Pair<Integer, Integer> getNumHistoricalsAndSegments(DruidCluster cluster) {
        int numHistoricals = 0;
        int numSegments = 0;
        for (Set set : cluster.getHistoricals().values()) {
            for (ServerHolder historical : set) {
                ++numHistoricals;
                numSegments += historical.getServer().getNumSegments() + historical.getNumQueuedSegments();
            }
        }
        return Pair.of((Object)numHistoricals, (Object)numSegments);
    }
}

