/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.inject.Inject;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.InventoryView;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.server.http.InventoryViewUtils;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

@Path(value="/druid/coordinator/v1/intervals")
public class IntervalsResource {
    private final InventoryView serverInventoryView;
    private final AuthConfig authConfig;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public IntervalsResource(InventoryView serverInventoryView, AuthConfig authConfig, AuthorizerMapper authorizerMapper) {
        this.serverInventoryView = serverInventoryView;
        this.authConfig = authConfig;
        this.authorizerMapper = authorizerMapper;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getIntervals(@Context HttpServletRequest req) {
        Comparator comparator = Comparators.intervalsByStartThenEnd().reversed();
        SortedSet<ImmutableDruidDataSource> datasources = InventoryViewUtils.getSecuredDataSources(req, this.serverInventoryView, this.authorizerMapper);
        TreeMap<Interval, Map<String, Map<String, Object>>> retVal = new TreeMap<Interval, Map<String, Map<String, Object>>>(comparator);
        for (ImmutableDruidDataSource dataSource : datasources) {
            for (DataSegment dataSegment : dataSource.getSegments()) {
                retVal.computeIfAbsent(dataSegment.getInterval(), i -> new HashMap());
                this.setProperties(retVal, dataSource, dataSegment);
            }
        }
        return Response.ok(retVal).build();
    }

    @GET
    @Path(value="/{interval}")
    @Produces(value={"application/json"})
    public Response getSpecificIntervals(@PathParam(value="interval") String interval, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full, @Context HttpServletRequest req) {
        Interval theInterval = Intervals.of((String)interval.replace('_', '/'));
        SortedSet<ImmutableDruidDataSource> datasources = InventoryViewUtils.getSecuredDataSources(req, this.serverInventoryView, this.authorizerMapper);
        Comparator comparator = Comparators.intervalsByStartThenEnd().reversed();
        if (full != null) {
            TreeMap<Interval, Map<String, Map<String, Object>>> retVal = new TreeMap<Interval, Map<String, Map<String, Object>>>(comparator);
            for (ImmutableDruidDataSource dataSource : datasources) {
                for (DataSegment dataSegment : dataSource.getSegments()) {
                    if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                    retVal.computeIfAbsent(dataSegment.getInterval(), k -> new HashMap());
                    this.setProperties(retVal, dataSource, dataSegment);
                }
            }
            return Response.ok(retVal).build();
        }
        if (simple != null) {
            HashMap<Interval, HashMap<String, Long>> retVal = new HashMap<Interval, HashMap<String, Long>>();
            for (ImmutableDruidDataSource dataSource : datasources) {
                for (DataSegment dataSegment : dataSource.getSegments()) {
                    if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                    HashMap<String, Long> properties = (HashMap<String, Long>)retVal.get(dataSegment.getInterval());
                    if (properties == null) {
                        properties = new HashMap<String, Long>();
                        properties.put("size", dataSegment.getSize());
                        properties.put("count", (Long)1);
                        retVal.put(dataSegment.getInterval(), properties);
                        continue;
                    }
                    properties.put("size", MapUtils.getLong(properties, (String)"size", (Long)0L) + dataSegment.getSize());
                    properties.put("count", (Long)(MapUtils.getInt(properties, (String)"count", (Integer)0) + 1));
                }
            }
            return Response.ok(retVal).build();
        }
        HashMap<String, Number> retVal = new HashMap<String, Number>();
        for (ImmutableDruidDataSource dataSource : datasources) {
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                retVal.put("size", MapUtils.getLong(retVal, (String)"size", (Long)0L) + dataSegment.getSize());
                retVal.put("count", MapUtils.getInt(retVal, (String)"count", (Integer)0) + 1);
            }
        }
        return Response.ok(retVal).build();
    }

    private void setProperties(Map<Interval, Map<String, Map<String, Object>>> retVal, ImmutableDruidDataSource dataSource, DataSegment dataSegment) {
        Map<String, Object> properties = retVal.get(dataSegment.getInterval()).get(dataSource.getName());
        if (properties == null) {
            properties = new HashMap<String, Object>();
            properties.put("size", dataSegment.getSize());
            properties.put("count", 1);
            retVal.get(dataSegment.getInterval()).put(dataSource.getName(), properties);
        } else {
            properties.put("size", MapUtils.getLong(properties, (String)"size", (Long)0L) + dataSegment.getSize());
            properties.put("count", MapUtils.getInt(properties, (String)"count", (Integer)0) + 1);
        }
    }
}

