/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.jetty.JettyBindings;
import org.apache.druid.server.initialization.jetty.JettyRequestLog;
import org.apache.druid.server.initialization.jetty.ServletFilterHolder;
import org.apache.druid.server.security.AllowHttpMethodsResourceFilter;
import org.eclipse.jetty.rewrite.handler.HeaderPatternRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class JettyServerInitUtils {
    private static final String[] GZIP_METHODS = new String[]{"GET", "POST"};

    public static GzipHandler wrapWithDefaultGzipHandler(Handler handler, int inflateBufferSize, int compressionLevel) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMinGzipSize(0);
        gzipHandler.setIncludedMethods(GZIP_METHODS);
        gzipHandler.setInflateBufferSize(inflateBufferSize);
        gzipHandler.setCompressionLevel(compressionLevel);
        gzipHandler.setCheckGzExists(false);
        gzipHandler.setHandler(handler);
        return gzipHandler;
    }

    public static void addQosFilters(ServletContextHandler handler, Injector injector) {
        Set filters = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<JettyBindings.QosFilterHolder>>(){}));
        JettyServerInitUtils.addFilters(handler, filters);
    }

    public static void addExtensionFilters(ServletContextHandler handler, Injector injector) {
        Set filters = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ServletFilterHolder>>(){}));
        JettyServerInitUtils.addFilters(handler, filters);
    }

    public static void addFilters(ServletContextHandler handler, Set<? extends ServletFilterHolder> filterHolders) {
        for (ServletFilterHolder servletFilterHolder : filterHolders) {
            FilterHolder holder;
            if (servletFilterHolder.getFilter() != null) {
                holder = new FilterHolder(servletFilterHolder.getFilter());
            } else if (servletFilterHolder.getFilterClass() != null) {
                holder = new FilterHolder(servletFilterHolder.getFilterClass());
            } else {
                throw new ISE("Filter[%s] for paths[%s] didn't have a Filter!?", new Object[]{servletFilterHolder, Arrays.toString(servletFilterHolder.getPaths())});
            }
            if (servletFilterHolder.getInitParameters() != null) {
                holder.setInitParameters(servletFilterHolder.getInitParameters());
            }
            FilterMapping filterMapping = new FilterMapping();
            filterMapping.setFilterName(holder.getName());
            filterMapping.setPathSpecs(servletFilterHolder.getPaths());
            filterMapping.setDispatcherTypes(servletFilterHolder.getDispatcherType());
            handler.getServletHandler().addFilter(holder, filterMapping);
        }
    }

    public static Handler getJettyRequestLogHandler() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)new JettyRequestLog());
        return requestLogHandler;
    }

    public static void addAllowHttpMethodsFilter(ServletContextHandler root, List<String> allowedHttpMethods) {
        FilterHolder holder = new FilterHolder((Filter)new AllowHttpMethodsResourceFilter(allowedHttpMethods));
        root.addFilter(holder, "/*", null);
    }

    public static void maybeAddHSTSPatternRule(ServerConfig serverConfig, RewriteHandler rewriteHandler) {
        if (serverConfig.isEnableHSTS()) {
            rewriteHandler.addRule((Rule)JettyServerInitUtils.getHSTSHeaderPattern());
        }
    }

    public static void maybeAddHSTSRewriteHandler(ServerConfig serverConfig, HandlerList handlerList) {
        if (serverConfig.isEnableHSTS()) {
            RewriteHandler rewriteHandler = new RewriteHandler();
            rewriteHandler.addRule((Rule)JettyServerInitUtils.getHSTSHeaderPattern());
            handlerList.addHandler((Handler)rewriteHandler);
        }
    }

    private static HeaderPatternRule getHSTSHeaderPattern() {
        return new HeaderPatternRule("*", "Strict-Transport-Security", "max-age=63072000; includeSubDomains");
    }
}

