/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.AlertBuilder;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.security.Authenticator;

public class PreResponseAuthorizationCheckFilter
implements Filter {
    private static final EmittingLogger log = new EmittingLogger(PreResponseAuthorizationCheckFilter.class);
    private final List<Authenticator> authenticators;
    private final ObjectMapper jsonMapper;

    public PreResponseAuthorizationCheckFilter(List<Authenticator> authenticators, ObjectMapper jsonMapper) {
        this.authenticators = authenticators;
        this.jsonMapper = jsonMapper;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (servletRequest.getAttribute("Druid-Authentication-Result") == null) {
            this.handleUnauthenticatedRequest(response);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
        Boolean authInfoChecked = (Boolean)servletRequest.getAttribute("Druid-Authorization-Checked");
        if (authInfoChecked == null && PreResponseAuthorizationCheckFilter.statusShouldBeHidden(response.getStatus())) {
            this.handleAuthorizationCheckError(StringUtils.format((String)"Request did not have an authorization check performed, original response status [%s].", (Object[])new Object[]{response.getStatus()}), request, response);
        }
        if (authInfoChecked != null && !authInfoChecked.booleanValue() && response.getStatus() != 403) {
            this.handleAuthorizationCheckError("Request's authorization check failed but status code was not 403", request, response);
        }
    }

    public void destroy() {
    }

    private void handleUnauthenticatedRequest(HttpServletResponse response) throws IOException {
        HashSet<String> supportedAuthSchemes = new HashSet<String>();
        for (Authenticator authenticator : this.authenticators) {
            String challengeHeader = authenticator.getAuthChallengeHeader();
            if (challengeHeader == null) continue;
            supportedAuthSchemes.add(challengeHeader);
        }
        for (String authScheme : supportedAuthSchemes) {
            response.addHeader("WWW-Authenticate", authScheme);
        }
        QueryInterruptedException unauthorizedError = new QueryInterruptedException("Unauthorized request", null, null, DruidNode.getDefaultHost());
        unauthorizedError.setStackTrace(new StackTraceElement[0]);
        ServletOutputStream out = response.getOutputStream();
        PreResponseAuthorizationCheckFilter.sendJsonError(response, 401, this.jsonMapper.writeValueAsString((Object)unauthorizedError), (OutputStream)out);
        out.close();
    }

    private void handleAuthorizationCheckError(String errorMsg, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        String queryId;
        AlertBuilder builder = log.makeAlert(errorMsg, new Object[0]).addData("uri", (Object)servletRequest.getRequestURI()).addData("method", (Object)servletRequest.getMethod()).addData("remoteAddr", (Object)servletRequest.getRemoteAddr());
        String remoteHost = servletRequest.getRemoteHost();
        if (remoteHost != null && !remoteHost.equals(servletRequest.getRemoteAddr())) {
            builder.addData("remoteHost", (Object)remoteHost);
        }
        if ((queryId = servletResponse.getHeader("X-Druid-Query-Id")) != null) {
            builder.addData("queryId", (Object)queryId);
        }
        builder.emit();
        if (!servletResponse.isCommitted()) {
            try {
                servletResponse.reset();
                servletResponse.setStatus(403);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean statusShouldBeHidden(int status) {
        return status / 100 == 2;
    }

    public static void sendJsonError(HttpServletResponse resp, int error, String errorJson, OutputStream outputStream) {
        resp.setStatus(error);
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        try {
            outputStream.write(errorJson.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ioe) {
            log.error("Can't get writer from HTTP response.", new Object[0]);
        }
    }
}

