/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.namespace;

import com.google.common.base.Strings;
import java.sql.Timestamp;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.druid.data.input.MapPopulator;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.namespace.CacheGenerator;
import org.apache.druid.query.lookup.namespace.JdbcExtractionNamespace;
import org.apache.druid.server.lookup.namespace.cache.CacheHandler;
import org.apache.druid.server.lookup.namespace.cache.CacheScheduler;
import org.apache.druid.utils.JvmUtils;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.TimestampMapper;

public final class JdbcCacheGenerator
implements CacheGenerator<JdbcExtractionNamespace> {
    private static final Logger LOG = new Logger(JdbcCacheGenerator.class);
    private static final String NO_SUITABLE_DRIVER_FOUND_ERROR = "No suitable driver found";
    private static final String JDBC_DRIVER_JAR_FILES_MISSING_ERROR = "JDBC driver JAR files missing from extensions/druid-lookups-cached-global directory";
    private static final long MAX_MEMORY = JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes();
    private final ConcurrentMap<CacheScheduler.EntryImpl<JdbcExtractionNamespace>, DBI> dbiCache = new ConcurrentHashMap<CacheScheduler.EntryImpl<JdbcExtractionNamespace>, DBI>();

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public String generateCache(JdbcExtractionNamespace namespace, CacheScheduler.EntryImpl<JdbcExtractionNamespace> entryId, String lastVersion, CacheHandler cache) {
        Long lastDBUpdate;
        long lastCheck = lastVersion == null ? -4611686018427387904L : Long.parseLong(lastVersion);
        try {
            lastDBUpdate = this.lastUpdates(entryId, namespace);
            if (lastDBUpdate != null && lastDBUpdate <= lastCheck) {
                return null;
            }
        }
        catch (UnableToObtainConnectionException e) {
            if (e.getMessage().contains(NO_SUITABLE_DRIVER_FOUND_ERROR)) {
                throw new ISE((Throwable)e, JDBC_DRIVER_JAR_FILES_MISSING_ERROR, new Object[0]);
            }
            throw e;
        }
        long dbQueryStart = System.currentTimeMillis();
        LOG.debug("Updating %s", new Object[]{entryId});
        String newVersion = lastDBUpdate != null ? lastDBUpdate.toString() : StringUtils.format((String)"%d", (Object[])new Object[]{dbQueryStart});
        long startNs = System.nanoTime();
        try (Handle handle = this.getHandle(entryId, namespace);){
            String string;
            block22: {
                ResultIterator<Pair<String, String>> pairs = this.getLookupPairs(handle, namespace);
                try {
                    MapPopulator.PopulateResult populateResult = MapPopulator.populateAndWarnAtByteLimit(pairs, cache.getCache(), (long)((double)(MAX_MEMORY * namespace.getMaxHeapPercentage()) / 100.0), null == entryId ? null : entryId.toString());
                    long duration = System.nanoTime() - startNs;
                    LOG.info("Finished loading %d values (%d bytes) for [%s] in %d ns", new Object[]{populateResult.getEntries(), populateResult.getBytes(), entryId, duration});
                    string = newVersion;
                    if (pairs == null) break block22;
                }
                catch (Throwable throwable) {
                    if (pairs != null) {
                        try {
                            pairs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pairs.close();
            }
            return string;
        }
        catch (UnableToObtainConnectionException e) {
            if (e.getMessage().contains(NO_SUITABLE_DRIVER_FOUND_ERROR)) {
                throw new ISE((Throwable)e, JDBC_DRIVER_JAR_FILES_MISSING_ERROR, new Object[0]);
            }
            throw e;
        }
        catch (Throwable t) {
            try {
                cache.close();
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    private Handle getHandle(CacheScheduler.EntryImpl<JdbcExtractionNamespace> key, JdbcExtractionNamespace namespace) {
        DBI dbi = this.ensureDBI(key, namespace);
        return dbi.open();
    }

    private ResultIterator<Pair<String, String>> getLookupPairs(Handle handle, JdbcExtractionNamespace namespace) {
        String table = namespace.getTable();
        String filter = namespace.getFilter();
        String valueColumn = namespace.getValueColumn();
        String keyColumn = namespace.getKeyColumn();
        return handle.createQuery(JdbcCacheGenerator.buildLookupQuery(table, filter, keyColumn, valueColumn)).map((index1, r1, ctx1) -> new Pair((Object)r1.getString(1), (Object)r1.getString(2))).iterator();
    }

    private static String buildLookupQuery(String table, String filter, String keyColumn, String valueColumn) {
        if (Strings.isNullOrEmpty((String)filter)) {
            return StringUtils.format((String)"SELECT %s, %s FROM %s WHERE %s IS NOT NULL", (Object[])new Object[]{keyColumn, valueColumn, table, valueColumn});
        }
        return StringUtils.format((String)"SELECT %s, %s FROM %s WHERE %s AND %s IS NOT NULL", (Object[])new Object[]{keyColumn, valueColumn, table, filter, valueColumn});
    }

    private DBI ensureDBI(CacheScheduler.EntryImpl<JdbcExtractionNamespace> key, JdbcExtractionNamespace namespace) {
        DBI dbi = null;
        if (this.dbiCache.containsKey(key)) {
            dbi = (DBI)this.dbiCache.get(key);
        }
        if (dbi == null) {
            DBI newDbi = new DBI(namespace.getConnectorConfig().getConnectURI(), namespace.getConnectorConfig().getUser(), namespace.getConnectorConfig().getPassword());
            this.dbiCache.putIfAbsent(key, newDbi);
            dbi = (DBI)this.dbiCache.get(key);
        }
        return dbi;
    }

    @Nullable
    private Long lastUpdates(CacheScheduler.EntryImpl<JdbcExtractionNamespace> key, JdbcExtractionNamespace namespace) {
        DBI dbi = this.ensureDBI(key, namespace);
        String table = namespace.getTable();
        String tsColumn = namespace.getTsColumn();
        if (tsColumn == null) {
            return null;
        }
        String query = StringUtils.format((String)"SELECT MAX(%s) FROM %s", (Object[])new Object[]{tsColumn, table});
        Timestamp update = (Timestamp)dbi.withHandle(handle -> (Timestamp)handle.createQuery(query).map((ResultSetMapper)TimestampMapper.FIRST).first());
        if (update == null) {
            LOG.info("Lookup table[%s] is empty. No rows returned for the query[%s].", new Object[]{table, query});
            return null;
        }
        return update.getTime();
    }
}

