/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.hadoop;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.hadoop.WindowedDataSegment;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class DatasourceInputSplit
extends InputSplit
implements Writable {
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    private List<WindowedDataSegment> segments = null;
    private String[] locations = null;

    public DatasourceInputSplit() {
    }

    public DatasourceInputSplit(@NotNull List<WindowedDataSegment> segments, String[] locations) {
        Preconditions.checkArgument((segments != null && segments.size() > 0 ? 1 : 0) != 0, (Object)"no segments");
        this.segments = segments;
        this.locations = locations == null ? EMPTY_STR_ARRAY : locations;
    }

    public long getLength() {
        long size = 0L;
        for (WindowedDataSegment segment : this.segments) {
            size += segment.getSegment().getSize();
        }
        return size;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public List<WindowedDataSegment> getSegments() {
        return this.segments;
    }

    public void write(DataOutput out) throws IOException {
        byte[] segmentsBytes = HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsBytes(this.segments);
        out.writeInt(segmentsBytes.length);
        out.write(segmentsBytes);
        out.writeInt(this.locations.length);
        for (String location : this.locations) {
            out.writeUTF(location);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int segmentsBytesLength = in.readInt();
        byte[] buf = new byte[segmentsBytesLength];
        in.readFully(buf);
        this.segments = (List)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(buf, (TypeReference)new TypeReference<List<WindowedDataSegment>>(){});
        this.locations = new String[in.readInt()];
        for (int i = 0; i < this.locations.length; ++i) {
            this.locations[i] = in.readUTF();
        }
    }
}

