/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SurrogateTaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.common.task.FilteringCloseableInputRowIterator;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.DimensionCardinalityReport;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PerfectRollupWorkerTask;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.partition.HashPartitioner;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class PartialDimensionCardinalityTask
extends PerfectRollupWorkerTask {
    public static final String TYPE = "partial_dimension_cardinality";
    private final int numAttempts;
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final String subtaskSpecId;
    private final ObjectMapper jsonMapper;

    @JsonCreator
    PartialDimensionCardinalityTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="subtaskSpecId") @Nullable String subtaskSpecId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") ParallelIndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject ObjectMapper jsonMapper) {
        super(PartialDimensionCardinalityTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, ingestionSchema.getDataSchema(), ingestionSchema.getTuningConfig(), context, supervisorTaskId);
        Preconditions.checkArgument((boolean)(ingestionSchema.getTuningConfig().getPartitionsSpec() instanceof HashedPartitionsSpec), (String)"%s partitionsSpec required", (Object)"hashed");
        this.subtaskSpecId = subtaskSpecId;
        this.numAttempts = numAttempts;
        this.ingestionSchema = ingestionSchema;
        this.jsonMapper = jsonMapper;
    }

    @JsonProperty
    private int getNumAttempts() {
        return this.numAttempts;
    }

    @JsonProperty(value="spec")
    private ParallelIndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @Override
    @JsonProperty
    public String getSubtaskSpecId() {
        return this.subtaskSpecId;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return this.getIngestionSchema().getIOConfig().getInputSource() != null ? this.getIngestionSchema().getIOConfig().getInputSource().getTypes().stream().map(i -> new ResourceAction(new Resource(i, "EXTERNAL"), Action.READ)).collect(Collectors.toSet()) : ImmutableSet.of();
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        if (!this.getIngestionSchema().getDataSchema().getGranularitySpec().inputIntervals().isEmpty()) {
            return this.tryTimeChunkLock(new SurrogateTaskActionClient(this.getSupervisorTaskId(), taskActionClient), this.getIngestionSchema().getDataSchema().getGranularitySpec().inputIntervals());
        }
        return true;
    }

    @Override
    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        DataSchema dataSchema = this.ingestionSchema.getDataSchema();
        GranularitySpec granularitySpec = dataSchema.getGranularitySpec();
        ParallelIndexTuningConfig tuningConfig = this.ingestionSchema.getTuningConfig();
        HashedPartitionsSpec partitionsSpec = (HashedPartitionsSpec)tuningConfig.getPartitionsSpec();
        Preconditions.checkNotNull((Object)partitionsSpec, (Object)"partitionsSpec required in tuningConfig");
        InputSource inputSource = this.ingestionSchema.getIOConfig().getNonNullInputSource(toolbox);
        InputFormat inputFormat = inputSource.needsFormat() ? ParallelIndexSupervisorTask.getInputFormat(this.ingestionSchema) : null;
        RowIngestionMeters buildSegmentsMeters = toolbox.getRowIngestionMetersFactory().createRowIngestionMeters();
        ParseExceptionHandler parseExceptionHandler = new ParseExceptionHandler(buildSegmentsMeters, tuningConfig.isLogParseExceptions(), tuningConfig.getMaxParseExceptions(), tuningConfig.getMaxSavedParseExceptions());
        try (FilteringCloseableInputRowIterator inputRowIterator = AbstractBatchIndexTask.inputSourceReader(toolbox.getIndexingTmpDir(), dataSchema, inputSource, inputFormat, PartialDimensionCardinalityTask.allowNonNullRowsWithinInputIntervalsOf(granularitySpec), buildSegmentsMeters, parseExceptionHandler);){
            Map<Interval, byte[]> cardinalities = this.determineCardinalities(inputRowIterator, granularitySpec);
            this.sendReport(toolbox, new DimensionCardinalityReport(this.getId(), cardinalities));
        }
        return TaskStatus.success((String)this.getId());
    }

    private Map<Interval, byte[]> determineCardinalities(CloseableIterator<InputRow> inputRowIterator, GranularitySpec granularitySpec) {
        HashMap<Interval, HllSketch> intervalToCardinalities = new HashMap<Interval, HllSketch>();
        while (inputRowIterator.hasNext()) {
            Interval interval;
            InputRow inputRow = (InputRow)inputRowIterator.next();
            DateTime timestamp = inputRow.getTimestamp();
            if (granularitySpec.inputIntervals().isEmpty()) {
                interval = granularitySpec.getSegmentGranularity().bucket(timestamp);
            } else {
                Optional optInterval = granularitySpec.bucketInterval(timestamp);
                assert (optInterval.isPresent());
                interval = (Interval)optInterval.get();
            }
            Granularity queryGranularity = granularitySpec.getQueryGranularity();
            HllSketch hllSketch = intervalToCardinalities.computeIfAbsent(interval, intervalKey -> DimensionCardinalityReport.createHllSketchForReport());
            List groupKey = HashPartitioner.extractKeys(Collections.emptyList(), (long)queryGranularity.bucketStart(timestamp).getMillis(), (InputRow)inputRow);
            try {
                hllSketch.update(this.jsonMapper.writeValueAsBytes((Object)groupKey));
            }
            catch (JsonProcessingException jpe) {
                throw new RuntimeException(jpe);
            }
        }
        HashMap<Interval, byte[]> newMap = new HashMap<Interval, byte[]>();
        for (Map.Entry entry : intervalToCardinalities.entrySet()) {
            newMap.put((Interval)entry.getKey(), ((HllSketch)entry.getValue()).toCompactByteArray());
        }
        return newMap;
    }

    private void sendReport(TaskToolbox toolbox, DimensionCardinalityReport report) {
        ParallelIndexSupervisorTaskClient taskClient = toolbox.getSupervisorTaskClientProvider().build(this.getSupervisorTaskId(), this.ingestionSchema.getTuningConfig().getChatHandlerTimeout(), this.ingestionSchema.getTuningConfig().getChatHandlerNumRetries());
        taskClient.report(report);
    }
}

