/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.tasklogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class ConsoleLoggingEnforcementConfigurationFactory
extends ConfigurationFactory {
    private static final Logger log = new Logger(ConsoleLoggingEnforcementConfigurationFactory.class);
    public static final String[] SUFFIXES = new String[]{".xml", "*"};

    public String[] getSupportedTypes() {
        return SUFFIXES;
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return new OverrideConfiguration(loggerContext, source);
    }

    static {
        Configurator.setLevel((String)log.getName(), (Level)Level.WARN);
    }

    static class OverrideConfiguration
    extends XmlConfiguration {
        public OverrideConfiguration(LoggerContext loggerContext, ConfigurationSource configSource) {
            super(loggerContext, configSource);
        }

        protected void doConfigure() {
            super.doConfigure();
            List<Appender> consoleAppenders = this.findConsoleAppenders();
            if (consoleAppenders.isEmpty()) {
                ConsoleAppender injectedConsoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("_Injected_Console_Appender_")).setLayout((Layout)PatternLayout.newBuilder().withPattern("%d{ISO8601} %p [%t] %c - %m%n").build())).build();
                injectedConsoleAppender.start();
                consoleAppenders.add((Appender)injectedConsoleAppender);
            }
            ArrayList<Object> loggerConfigList = new ArrayList<Object>();
            loggerConfigList.add(this.getRootLogger());
            loggerConfigList.addAll(this.getLoggers().values());
            for (LoggerConfig loggerConfig : loggerConfigList) {
                this.applyConsoleAppender(loggerConfig, consoleAppenders);
            }
        }

        @Nonnull
        private List<Appender> findConsoleAppenders() {
            ArrayList<Appender> consoleAppenders = new ArrayList<Appender>();
            for (Map.Entry entry : this.getAppenders().entrySet()) {
                Appender appender = (Appender)entry.getValue();
                if (!(appender instanceof ConsoleAppender)) continue;
                consoleAppenders.add(appender);
            }
            return consoleAppenders;
        }

        private void applyConsoleAppender(LoggerConfig logger, List<Appender> consoleAppenders) {
            List consoleAppenderNames = consoleAppenders.stream().map(Appender::getName).collect(Collectors.toList());
            for (AppenderRef appenderRef : logger.getAppenderRefs()) {
                if (!consoleAppenderNames.contains(appenderRef.getRef())) continue;
                return;
            }
            Level level = Level.INFO;
            Filter filter = null;
            Appender consoleAppender = consoleAppenders.get(0);
            if (!logger.getAppenderRefs().isEmpty()) {
                AppenderRef appenderRef = (AppenderRef)logger.getAppenderRefs().get(0);
                List<String> appendRefs = logger.getAppenderRefs().stream().map(AppenderRef::getRef).collect(Collectors.toList());
                appendRefs.forEach(arg_0 -> ((LoggerConfig)logger).removeAppender(arg_0));
                level = appenderRef.getLevel();
                filter = appenderRef.getFilter();
                log.warn("Clearing all configured appenders for logger %s. Using %s instead.", new Object[]{logger.toString(), consoleAppender.getName()});
            }
            logger.addAppender(consoleAppender, level, filter);
        }
    }
}

