/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class WorkerCategorySpec {
    private final Map<String, CategoryConfig> categoryMap;
    private final boolean strong;

    @JsonCreator
    public WorkerCategorySpec(@JsonProperty(value="categoryMap") Map<String, CategoryConfig> categoryMap, @JsonProperty(value="strong") boolean strong) {
        this.categoryMap = categoryMap == null ? Collections.emptyMap() : categoryMap;
        this.strong = strong;
    }

    @JsonProperty
    public Map<String, CategoryConfig> getCategoryMap() {
        return this.categoryMap;
    }

    @JsonProperty
    public boolean isStrong() {
        return this.strong;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerCategorySpec that = (WorkerCategorySpec)o;
        return this.strong == that.strong && Objects.equals(this.categoryMap, that.categoryMap);
    }

    public int hashCode() {
        return Objects.hash(this.categoryMap, this.strong);
    }

    public String toString() {
        return "WorkerCategorySpec{categoryMap=" + String.valueOf(this.categoryMap) + ", strong=" + this.strong + "}";
    }

    public static class CategoryConfig {
        private final String defaultCategory;
        private final Map<String, String> categoryAffinity;

        @JsonCreator
        public CategoryConfig(@JsonProperty(value="defaultCategory") String defaultCategory, @JsonProperty(value="categoryAffinity") Map<String, String> categoryAffinity) {
            this.defaultCategory = defaultCategory;
            this.categoryAffinity = categoryAffinity == null ? Collections.emptyMap() : categoryAffinity;
        }

        @JsonProperty
        public String getDefaultCategory() {
            return this.defaultCategory;
        }

        @JsonProperty
        public Map<String, String> getCategoryAffinity() {
            return this.categoryAffinity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CategoryConfig that = (CategoryConfig)o;
            return Objects.equals(this.defaultCategory, that.defaultCategory) && Objects.equals(this.categoryAffinity, that.categoryAffinity);
        }

        public int hashCode() {
            return Objects.hash(this.defaultCategory, this.categoryAffinity);
        }

        public String toString() {
            return "CategoryConfig{defaultCategory=" + this.defaultCategory + ", categoryAffinity=" + String.valueOf(this.categoryAffinity) + "}";
        }
    }
}

