/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManagerConfig;
import org.apache.druid.indexing.seekablestream.common.StreamException;

public class SeekableStreamSupervisorStateManager
extends SupervisorStateManager {
    public SeekableStreamSupervisorStateManager(SupervisorStateManagerConfig supervisorConfig, boolean suspended) {
        super(supervisorConfig, suspended);
    }

    protected SupervisorStateManager.State getSpecificUnhealthySupervisorState() {
        SupervisorStateManager.ExceptionEvent event = (SupervisorStateManager.ExceptionEvent)this.getRecentEventsQueue().getLast();
        if (event instanceof SeekableStreamExceptionEvent && ((SeekableStreamExceptionEvent)event).isStreamException()) {
            return this.isAtLeastOneSuccessfulRun() ? SeekableStreamState.LOST_CONTACT_WITH_STREAM : SeekableStreamState.UNABLE_TO_CONNECT_TO_STREAM;
        }
        return SupervisorStateManager.BasicState.UNHEALTHY_SUPERVISOR;
    }

    protected SupervisorStateManager.ExceptionEvent buildExceptionEvent(Throwable t) {
        return new SeekableStreamExceptionEvent(t, this.isStoreStackTrace());
    }

    public static class SeekableStreamExceptionEvent
    extends SupervisorStateManager.ExceptionEvent {
        private final boolean streamException;

        public SeekableStreamExceptionEvent(Throwable t, boolean storeStackTrace) {
            super(t, storeStackTrace);
            this.streamException = ExceptionUtils.indexOfType((Throwable)t, StreamException.class) != -1;
        }

        @JsonProperty
        public boolean isStreamException() {
            return this.streamException;
        }

        protected boolean shouldSkipException(String className) {
            return RuntimeException.class.getName().equals(className) || StreamException.class.getName().equals(className);
        }
    }

    public static enum SeekableStreamState implements SupervisorStateManager.State
    {
        UNABLE_TO_CONNECT_TO_STREAM(false, true),
        LOST_CONTACT_WITH_STREAM(false, false),
        CONNECTING_TO_STREAM(true, true),
        DISCOVERING_INITIAL_TASKS(true, true),
        CREATING_TASKS(true, true);

        private final boolean healthy;
        private final boolean firstRunOnly;

        private SeekableStreamState(boolean healthy, boolean firstRunOnly) {
            this.healthy = healthy;
            this.firstRunOnly = firstRunOnly;
        }

        public boolean isHealthy() {
            return this.healthy;
        }

        public boolean isFirstRunOnly() {
            return this.firstRunOnly;
        }

        public SupervisorStateManager.State getBasicState() {
            return this.healthy ? SupervisorStateManager.BasicState.RUNNING : SupervisorStateManager.BasicState.UNHEALTHY_SUPERVISOR;
        }
    }
}

