/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.kerberos;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.HttpCookie;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.kerberos.DruidKerberosAuthenticationHandler;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authenticator;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerException;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;

@JsonTypeName(value="kerberos")
public class KerberosAuthenticator
implements Authenticator {
    private static final Logger log = new Logger(KerberosAuthenticator.class);
    public static final String SIGNED_TOKEN_ATTRIBUTE = "signedToken";
    private final String serverPrincipal;
    private final String serverKeytab;
    private final String authToLocal;
    private final String cookieSignatureSecret;
    private final String authorizerName;
    private final String name;
    private LoginContext loginContext;

    @JsonCreator
    public KerberosAuthenticator(@JsonProperty(value="serverPrincipal") String serverPrincipal, @JsonProperty(value="serverKeytab") String serverKeytab, @JsonProperty(value="authToLocal") String authToLocal, @JsonProperty(value="cookieSignatureSecret") String cookieSignatureSecret, @JsonProperty(value="authorizerName") String authorizerName, @JsonProperty(value="name") String name, @JacksonInject @Self DruidNode node) {
        this.serverKeytab = serverKeytab;
        this.authToLocal = authToLocal == null ? "DEFAULT" : authToLocal;
        this.cookieSignatureSecret = cookieSignatureSecret;
        this.authorizerName = authorizerName;
        this.name = (String)Preconditions.checkNotNull((Object)name);
        try {
            this.serverPrincipal = SecurityUtil.getServerPrincipal((String)serverPrincipal, (String)node.getHost());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Filter getFilter() {
        return new AuthenticationFilter(){
            private Signer mySigner;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void init(FilterConfig filterConfig) throws ServletException {
                ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(AuthenticationFilter.class.getClassLoader());
                    super.init(filterConfig);
                    Object configPrefix = filterConfig.getInitParameter("config.prefix");
                    configPrefix = configPrefix != null ? (String)configPrefix + "." : "";
                    Properties config = this.getConfiguration((String)configPrefix, filterConfig);
                    String signatureSecret = config.getProperty((String)configPrefix + "signature.secret");
                    if (signatureSecret == null) {
                        signatureSecret = Long.toString(ThreadLocalRandom.current().nextLong());
                        log.warn("'signature.secret' configuration not set, using a random value as secret", new Object[0]);
                    }
                    final byte[] secretBytes = StringUtils.toUtf8((String)signatureSecret);
                    SignerSecretProvider signerSecretProvider = new SignerSecretProvider(){

                        public void init(Properties config, ServletContext servletContext, long tokenValidity) {
                        }

                        public byte[] getCurrentSecret() {
                            return secretBytes;
                        }

                        public byte[][] getAllSecrets() {
                            return new byte[][]{secretBytes};
                        }
                    };
                    this.mySigner = new Signer(signerSecretProvider);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(prevLoader);
                }
            }

            protected AuthenticationToken getToken(HttpServletRequest request) throws AuthenticationException {
                AuthenticationToken token = null;
                String tokenStr = null;
                Cookie[] cookies = request.getCookies();
                if (cookies != null) {
                    for (Cookie cookie : cookies) {
                        if (!cookie.getName().equals("hadoop.auth")) continue;
                        tokenStr = cookie.getValue();
                        try {
                            tokenStr = this.mySigner.verifyAndExtract(tokenStr);
                            break;
                        }
                        catch (SignerException ex) {
                            throw new AuthenticationException((Throwable)ex);
                        }
                    }
                }
                if (tokenStr != null) {
                    token = AuthenticationToken.parse(tokenStr);
                    if (!token.getType().equals(this.getAuthenticationHandler().getType())) {
                        throw new AuthenticationException("Invalid AuthenticationToken type");
                    }
                    if (token.isExpired()) {
                        throw new AuthenticationException("AuthenticationToken expired");
                    }
                }
                return token;
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
                if (request.getAttribute("Druid-Authentication-Result") != null) {
                    filterChain.doFilter(request, response);
                    return;
                }
                if (KerberosAuthenticator.this.loginContext == null) {
                    KerberosAuthenticator.this.initializeKerberosLogin();
                }
                this.doFilterSuper(request, response, filterChain);
            }

            private void doFilterSuper(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
                boolean unauthorizedResponse = true;
                int errCode = 401;
                AuthenticationException authenticationEx = null;
                Object httpRequest = (HttpServletRequest)request;
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                boolean isHttps = "https".equals(httpRequest.getScheme());
                try {
                    AuthenticationToken token;
                    boolean newToken = false;
                    try {
                        token = this.getToken((HttpServletRequest)httpRequest);
                    }
                    catch (AuthenticationException ex) {
                        log.warn("AuthenticationToken ignored: " + ex.getMessage(), new Object[0]);
                        authenticationEx = ex;
                        token = null;
                    }
                    if (this.getAuthenticationHandler().managementOperation(token, httpRequest, httpResponse)) {
                        if (token == null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Request [{%s}] triggering authentication", new Object[]{this.getRequestURL((HttpServletRequest)httpRequest)});
                            }
                            if ((token = this.getAuthenticationHandler().authenticate(httpRequest, httpResponse)) != null && token.getExpires() != 0L && token != AuthenticationToken.ANONYMOUS) {
                                token.setExpires(System.currentTimeMillis() + this.getValidity() * 1000L);
                            }
                            newToken = true;
                        }
                        if (token != null) {
                            unauthorizedResponse = false;
                            if (log.isDebugEnabled()) {
                                log.debug("Request [{%s}] user [{%s}] authenticated", new Object[]{this.getRequestURL((HttpServletRequest)httpRequest), token.getUserName()});
                            }
                            final AuthenticationToken authToken = token;
                            httpRequest = new HttpServletRequestWrapper((HttpServletRequest)httpRequest){

                                public String getAuthType() {
                                    return authToken.getType();
                                }

                                public String getRemoteUser() {
                                    return authToken.getUserName();
                                }

                                public Principal getUserPrincipal() {
                                    return authToken != AuthenticationToken.ANONYMOUS ? authToken : null;
                                }
                            };
                            if (newToken && !token.isExpired() && token != AuthenticationToken.ANONYMOUS) {
                                String signedToken = this.mySigner.sign(token.toString());
                                KerberosAuthenticator.tokenToAuthCookie(httpResponse, signedToken, this.getCookieDomain(), this.getCookiePath(), token.getExpires(), !token.isExpired() && token.getExpires() > 0L, isHttps);
                                request.setAttribute(KerberosAuthenticator.SIGNED_TOKEN_ATTRIBUTE, (Object)KerberosAuthenticator.tokenToCookieString(signedToken, this.getCookieDomain(), this.getCookiePath(), token.getExpires(), !token.isExpired() && token.getExpires() > 0L, isHttps));
                            }
                            request.setAttribute("Druid-Authentication-Result", (Object)new AuthenticationResult(token.getName(), KerberosAuthenticator.this.authorizerName, KerberosAuthenticator.this.name, null));
                            this.doFilter(filterChain, (HttpServletRequest)httpRequest, httpResponse);
                        }
                    } else {
                        unauthorizedResponse = false;
                    }
                }
                catch (AuthenticationException ex) {
                    errCode = 403;
                    authenticationEx = ex;
                    if (log.isDebugEnabled()) {
                        log.debug((Throwable)ex, "Authentication exception: " + ex.getMessage(), new Object[0]);
                    }
                    log.warn("Authentication exception: " + ex.getMessage(), new Object[0]);
                }
                if (unauthorizedResponse && !httpResponse.isCommitted()) {
                    KerberosAuthenticator.tokenToAuthCookie(httpResponse, "", this.getCookieDomain(), this.getCookiePath(), 0L, false, isHttps);
                    if (errCode == 401 && !httpResponse.containsHeader("WWW-Authenticate")) {
                        errCode = 403;
                    }
                    if (authenticationEx == null) {
                        filterChain.doFilter(request, response);
                    } else {
                        httpResponse.sendError(errCode, authenticationEx.getMessage());
                    }
                }
            }
        };
    }

    public Class<? extends Filter> getFilterClass() {
        return null;
    }

    public Map<String, String> getInitParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("kerberos.principal", this.serverPrincipal);
        params.put("kerberos.keytab", this.serverKeytab);
        params.put("type", DruidKerberosAuthenticationHandler.class.getName());
        params.put("kerberos.name.rules", this.authToLocal);
        if (this.cookieSignatureSecret != null) {
            params.put("signature.secret", this.cookieSignatureSecret);
        }
        return params;
    }

    public String getPath() {
        return "/*";
    }

    public EnumSet<DispatcherType> getDispatcherType() {
        return null;
    }

    public String getAuthChallengeHeader() {
        return "Negotiate";
    }

    public AuthenticationResult authenticateJDBCContext(Map<String, Object> context) {
        throw new UnsupportedOperationException("JDBC Kerberos auth not supported yet");
    }

    public void decorateProxyRequest(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest) {
        Object cookieToken = clientRequest.getAttribute(SIGNED_TOKEN_ATTRIBUTE);
        if (cookieToken != null && cookieToken instanceof String) {
            log.debug("Found cookie token will attache it to proxyRequest as cookie", new Object[0]);
            String authResult = (String)cookieToken;
            String existingCookies = proxyRequest.getCookies().stream().map(HttpCookie::toString).collect(Collectors.joining(";"));
            proxyRequest.header(HttpHeader.COOKIE, Joiner.on((String)";").join((Object)authResult, (Object)existingCookies, new Object[0]));
        }
    }

    private void initializeKerberosLogin() throws ServletException {
        try {
            if (this.serverPrincipal == null || this.serverPrincipal.trim().length() == 0) {
                throw new ServletException("Principal not defined in configuration");
            }
            String keytab = this.serverKeytab;
            if (keytab == null || keytab.trim().length() == 0) {
                throw new ServletException("Keytab not defined in configuration");
            }
            if (!new File(keytab).exists()) {
                throw new ServletException("Keytab does not exist: " + keytab);
            }
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(this.serverPrincipal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            DruidKerberosConfiguration kerberosConfiguration = new DruidKerberosConfiguration(keytab, this.serverPrincipal);
            log.info("Login using keytab " + keytab + ", for principal " + this.serverPrincipal, new Object[0]);
            this.loginContext = new LoginContext("", subject, null, kerberosConfiguration);
            this.loginContext.login();
            log.info("Initialized, principal %s from keytab %s", new Object[]{this.serverPrincipal, keytab});
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private static void tokenToAuthCookie(HttpServletResponse resp, String token, String domain, String path, long expires, boolean isCookiePersistent, boolean isSecure) {
        resp.addHeader("Set-Cookie", KerberosAuthenticator.tokenToCookieString(token, domain, path, expires, isCookiePersistent, isSecure));
    }

    private static String tokenToCookieString(String token, String domain, String path, long expires, boolean isCookiePersistent, boolean isSecure) {
        StringBuilder sb = new StringBuilder("hadoop.auth").append("=");
        if (token != null && token.length() > 0) {
            sb.append("\"").append(token).append("\"");
        }
        if (path != null) {
            sb.append("; Path=").append(path);
        }
        if (domain != null) {
            sb.append("; Domain=").append(domain);
        }
        if (expires >= 0L && isCookiePersistent) {
            Date date = new Date(expires);
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.ENGLISH);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            sb.append("; Expires=").append(df.format(date));
        }
        if (isSecure) {
            sb.append("; Secure");
        }
        sb.append("; HttpOnly");
        return sb.toString();
    }

    public static class DruidKerberosConfiguration
    extends Configuration {
        private String keytab;
        private String principal;

        public DruidKerberosConfiguration(String keytab, String principal) {
            this.keytab = keytab;
            this.principal = principal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (System.getProperty("java.vendor").contains("IBM")) {
                options.put("useKeytab", this.keytab.startsWith("file://") ? this.keytab : "file://" + this.keytab);
                options.put("principal", this.principal);
                options.put("credsType", "acceptor");
            } else {
                options.put("keyTab", this.keytab);
                options.put("principal", this.principal);
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "true");
                options.put("renewTGT", "true");
                options.put("isInitiator", "false");
            }
            options.put("refreshKrb5Config", "true");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                if (System.getProperty("java.vendor").contains("IBM")) {
                    options.put("useDefaultCcache", "true");
                    System.setProperty("KRB5CCNAME", ticketCache);
                    options.put("renewTGT", "true");
                    options.put("credsType", "both");
                } else {
                    options.put("ticketCache", ticketCache);
                }
            }
            if (log.isDebugEnabled()) {
                options.put("debug", "true");
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

