/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kerby.asn1.Asn1;
import org.apache.kerby.asn1.Tag;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import org.apache.kerby.kerberos.kerb.type.base.KrbError;
import org.apache.kerby.kerberos.kerb.type.base.KrbMessage;
import org.apache.kerby.kerberos.kerb.type.base.KrbMessageType;
import org.apache.kerby.kerberos.kerb.type.kdc.AsRep;
import org.apache.kerby.kerberos.kerb.type.kdc.AsReq;
import org.apache.kerby.kerberos.kerb.type.kdc.TgsRep;
import org.apache.kerby.kerberos.kerb.type.kdc.TgsReq;

public class KrbCodec {
    public static byte[] encode(Asn1Type krbObj) throws KrbException {
        try {
            return krbObj.encode();
        }
        catch (IOException e) {
            throw new KrbException("encode failed", (Throwable)e);
        }
    }

    public static void encode(Asn1Type krbObj, ByteBuffer buffer) throws KrbException {
        try {
            krbObj.encode(buffer);
        }
        catch (IOException e) {
            throw new KrbException("Encoding failed", (Throwable)e);
        }
    }

    public static void decode(byte[] content, Asn1Type value) throws KrbException {
        KrbCodec.decode(ByteBuffer.wrap(content), value);
    }

    public static void decode(ByteBuffer content, Asn1Type value) throws KrbException {
        try {
            value.decode(content);
        }
        catch (IOException e) {
            throw new KrbException("Decoding failed", (Throwable)e);
        }
    }

    public static <T extends Asn1Type> T decode(byte[] content, Class<T> krbType) throws KrbException {
        return KrbCodec.decode(ByteBuffer.wrap(content), krbType);
    }

    public static <T extends Asn1Type> T decode(ByteBuffer content, Class<T> krbType) throws KrbException {
        Asn1Type implObj;
        try {
            implObj = (Asn1Type)krbType.newInstance();
        }
        catch (Exception e) {
            throw new KrbException("Decoding failed", (Throwable)e);
        }
        try {
            implObj.decode(content);
        }
        catch (IOException e) {
            throw new KrbException("Decoding failed", (Throwable)e);
        }
        return (T)implObj;
    }

    public static KrbMessage decodeMessage(ByteBuffer buffer) throws IOException {
        KrbMessage msg;
        Asn1ParseResult parsingResult = Asn1.parse((ByteBuffer)buffer);
        Tag tag = parsingResult.tag();
        KrbMessageType msgType = KrbMessageType.fromValue(tag.tagNo());
        if (msgType == KrbMessageType.TGS_REQ) {
            msg = new TgsReq();
        } else if (msgType == KrbMessageType.AS_REP) {
            msg = new AsRep();
        } else if (msgType == KrbMessageType.AS_REQ) {
            msg = new AsReq();
        } else if (msgType == KrbMessageType.TGS_REP) {
            msg = new TgsRep();
        } else if (msgType == KrbMessageType.AP_REQ) {
            msg = new ApReq();
        } else if (msgType == KrbMessageType.AP_REP) {
            msg = new ApReq();
        } else if (msgType == KrbMessageType.KRB_ERROR) {
            msg = new KrbError();
        } else {
            throw new IOException("To be supported krb message type with tag: " + tag);
        }
        msg.decode(parsingResult);
        return msg;
    }
}

