/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.servlet.GuiceFilter;
import java.util.List;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.druid.cli.CliCoordinator;
import org.apache.druid.cli.CliOverlord;
import org.apache.druid.cli.WebConsoleJettyServerInitializer;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.server.http.OverlordProxyServlet;
import org.apache.druid.server.http.RedirectFilter;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.jetty.JettyServerInitUtils;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationUtils;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

class CoordinatorJettyServerInitializer
implements JettyServerInitializer {
    private static final List<String> UNSECURED_PATHS = ImmutableList.of((Object)"/coordinator/false", (Object)"/overlord/false", (Object)"/status/health", (Object)"/druid/coordinator/v1/isLeader");
    private final boolean beOverlord;
    private final ServerConfig serverConfig;

    @Inject
    CoordinatorJettyServerInitializer(Properties properties, ServerConfig serverConfig) {
        this.beOverlord = CliCoordinator.isOverlord(properties);
        this.serverConfig = serverConfig;
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        root.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
        root.addServlet(holderPwd, "/");
        AuthConfig authConfig = (AuthConfig)injector.getInstance(AuthConfig.class);
        ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
        JettyServerInitUtils.addQosFilters((ServletContextHandler)root, (Injector)injector);
        AuthenticationUtils.addSecuritySanityCheckFilter((ServletContextHandler)root, (ObjectMapper)jsonMapper);
        AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS);
        WebConsoleJettyServerInitializer.intializeServerForWebConsoleRoot(root);
        AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, (List)authConfig.getUnsecuredPaths());
        if (this.beOverlord) {
            AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, CliOverlord.UNSECURED_PATHS);
        }
        List authenticators = authenticatorMapper.getAuthenticatorChain();
        AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)authenticators);
        AuthenticationUtils.addAllowOptionsFilter((ServletContextHandler)root, (boolean)authConfig.isAllowUnauthenticatedHttpOptions());
        JettyServerInitUtils.addAllowHttpMethodsFilter((ServletContextHandler)root, (List)this.serverConfig.getAllowedHttpMethods());
        JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
        AuthenticationUtils.addPreResponseAuthorizationCheckFilter((ServletContextHandler)root, (List)authenticators, (ObjectMapper)jsonMapper);
        root.addFilter(GuiceFilter.class, "/status/*", null);
        root.addFilter(GuiceFilter.class, "/druid-internal/*", null);
        root.addFilter(new FilterHolder((Filter)injector.getInstance(RedirectFilter.class)), "/*", null);
        root.addFilter(GuiceFilter.class, "/info/*", null);
        root.addFilter(GuiceFilter.class, "/druid/coordinator/*", null);
        if (this.beOverlord) {
            root.addFilter(GuiceFilter.class, "/druid/indexer/*", null);
        }
        root.addFilter(GuiceFilter.class, "/druid-ext/*", null);
        root.addFilter(GuiceFilter.class, "/coordinator/*", null);
        if (!this.beOverlord) {
            root.addServlet(new ServletHolder((Servlet)injector.getInstance(OverlordProxyServlet.class)), "/druid/indexer/*");
        }
        RewriteHandler rewriteHandler = WebConsoleJettyServerInitializer.createWebConsoleRewriteHandler();
        JettyServerInitUtils.maybeAddHSTSPatternRule((ServerConfig)this.serverConfig, (RewriteHandler)rewriteHandler);
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{rewriteHandler, JettyServerInitUtils.getJettyRequestLogHandler(), JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root, (int)this.serverConfig.getInflateBufferSize(), (int)this.serverConfig.getCompressionLevel())});
        server.setHandler((Handler)handlerList);
    }
}

