/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client.interceptor;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class DiscardLimiter {
    private final AtomicBoolean isDone = new AtomicBoolean(Boolean.FALSE);
    private final AtomicBoolean isReadyState = new AtomicBoolean(Boolean.TRUE);
    private final AtomicLong discardCounter = new AtomicLong();
    private final AtomicBoolean reachDiscardCountForReconnect = new AtomicBoolean(Boolean.FALSE);
    private final AtomicBoolean reachNotReadyTimeout = new AtomicBoolean(Boolean.FALSE);
    private final long discardCountForReconnect;
    private final long notReadyTimeoutMillis;
    private final AtomicLong notReadyStartTimeMillis = new AtomicLong();

    public DiscardLimiter(long discardCountForReconnect, long notReadyTimeoutMillis) {
        this.discardCountForReconnect = discardCountForReconnect;
        this.notReadyTimeoutMillis = notReadyTimeoutMillis;
    }

    public void reset() {
        this.isDone.set(Boolean.FALSE);
        this.isReadyState.set(Boolean.TRUE);
        this.discardCounter.set(0L);
        this.reachDiscardCountForReconnect.set(Boolean.FALSE);
        this.reachNotReadyTimeout.set(Boolean.FALSE);
        this.notReadyStartTimeMillis.set(System.currentTimeMillis());
    }

    public void discard(boolean ready) throws DiscardLimiterException {
        if (ready) {
            if (this.isReadyState.compareAndSet(Boolean.FALSE, Boolean.TRUE)) {
                this.reset();
            }
            return;
        }
        if (this.isDone.get()) {
            return;
        }
        if (this.isReadyState.compareAndSet(Boolean.TRUE, Boolean.FALSE)) {
            this.notReadyStartTimeMillis.set(System.currentTimeMillis());
        }
        if (this.checkDiscardCountForReconnect() && this.checkNotReadyTimeout()) {
            this.isDone.set(Boolean.TRUE);
            long durationTimeMillis = System.currentTimeMillis() - this.notReadyStartTimeMillis.get();
            throw new DiscardLimiterException(this.discardCounter.get(), this.discardCountForReconnect, durationTimeMillis, this.notReadyTimeoutMillis);
        }
    }

    boolean checkDiscardCountForReconnect() {
        long discardCount = this.discardCounter.incrementAndGet();
        if (this.reachDiscardCountForReconnect.get()) {
            return true;
        }
        if (discardCount > this.discardCountForReconnect) {
            this.reachDiscardCountForReconnect.set(Boolean.TRUE);
            return true;
        }
        return false;
    }

    boolean checkNotReadyTimeout() {
        if (this.reachNotReadyTimeout.get()) {
            return true;
        }
        long notReadyDurationTimeMillis = System.currentTimeMillis() - this.notReadyStartTimeMillis.get();
        if (notReadyDurationTimeMillis > this.notReadyTimeoutMillis) {
            this.reachNotReadyTimeout.set(Boolean.TRUE);
            return true;
        }
        return false;
    }

    static class DiscardLimiterException
    extends Exception {
        public DiscardLimiterException(long discardCount, long discardCountForReconnect, long durationTimeMillis, long timeoutMillis) {
            super("reach the limit, discard=" + discardCount + "/" + discardCountForReconnect + ", duration=" + durationTimeMillis + "ms, timeout=" + timeoutMillis + "ms");
        }
    }
}

