/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server;

import com.navercorp.pinpoint.grpc.server.DefaultTransportMetadata;
import com.navercorp.pinpoint.grpc.server.TransportMetadata;
import io.grpc.Attributes;
import io.grpc.Grpc;
import io.grpc.Status;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class TransportMetadataFactory {
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private final String debugString;

    public TransportMetadataFactory(String debugString) {
        this.debugString = Objects.requireNonNull(debugString, "debugString");
    }

    public TransportMetadata build(Attributes attributes) {
        InetSocketAddress remoteSocketAddress = (InetSocketAddress)attributes.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
        if (remoteSocketAddress == null) {
            throw Status.INTERNAL.withDescription("RemoteSocketAddress is null").asRuntimeException();
        }
        InetSocketAddress localSocketAddress = (InetSocketAddress)attributes.get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR);
        if (localSocketAddress == null) {
            throw Status.INTERNAL.withDescription("LocalSocketAddress is null").asRuntimeException();
        }
        long transportId = idGenerator.getAndIncrement();
        long connectedTime = System.currentTimeMillis();
        return new DefaultTransportMetadata(this.debugString, remoteSocketAddress, localSocketAddress, transportId, connectedTime);
    }

    public String toString() {
        return "TransportMetadataFactory{debugString='" + this.debugString + '\'' + '}';
    }
}

