/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.sink.handler.impl;

import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpResponse;
import java.net.ConnectException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.http.HttpRetryConfig;
import org.apache.eventmesh.common.config.connector.http.SinkConnectorConfig;
import org.apache.eventmesh.connector.http.sink.data.HttpConnectRecord;
import org.apache.eventmesh.connector.http.sink.handler.AbstractHttpSinkHandler;
import org.apache.eventmesh.connector.http.sink.handler.HttpSinkHandler;
import org.apache.eventmesh.connector.http.util.HttpUtils;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSinkHandlerRetryWrapper
extends AbstractHttpSinkHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpSinkHandlerRetryWrapper.class);
    private final HttpRetryConfig httpRetryConfig;
    private final HttpSinkHandler sinkHandler;
    private final RetryPolicy<HttpResponse<Buffer>> retryPolicy;

    public HttpSinkHandlerRetryWrapper(SinkConnectorConfig sinkConnectorConfig, HttpSinkHandler sinkHandler) {
        super(sinkConnectorConfig);
        this.sinkHandler = sinkHandler;
        this.httpRetryConfig = this.getSinkConnectorConfig().getRetryConfig();
        this.retryPolicy = this.buildRetryPolicy();
    }

    private RetryPolicy<HttpResponse<Buffer>> buildRetryPolicy() {
        return ((RetryPolicyBuilder)((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handleIf(e -> e instanceof ConnectException)).handleResultIf(response -> this.httpRetryConfig.isRetryOnNonSuccess() && !HttpUtils.is2xxSuccessful(response.statusCode()))).withMaxRetries(this.httpRetryConfig.getMaxRetries()).withDelay(Duration.ofMillis(this.httpRetryConfig.getInterval())).onRetry(event -> {
            if (log.isDebugEnabled()) {
                log.warn("Failed to deliver message after {} attempts. Retrying in {} ms. Error: {}", new Object[]{event.getAttemptCount(), this.httpRetryConfig.getInterval(), event.getLastException()});
            } else {
                log.warn("Failed to deliver message after {} attempts. Retrying in {} ms.", (Object)event.getAttemptCount(), (Object)this.httpRetryConfig.getInterval());
            }
        }).onFailure(event -> {
            if (log.isDebugEnabled()) {
                log.error("Failed to deliver message after {} attempts. Error: {}", (Object)event.getAttemptCount(), (Object)event.getException());
            } else {
                log.error("Failed to deliver message after {} attempts.", (Object)event.getAttemptCount());
            }
        })).build();
    }

    @Override
    public void start() {
        this.sinkHandler.start();
    }

    @Override
    public Future<HttpResponse<Buffer>> deliver(URI url, HttpConnectRecord httpConnectRecord, Map<String, Object> attributes, ConnectRecord connectRecord) {
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).getStageAsync(() -> this.sinkHandler.deliver(url, httpConnectRecord, attributes, connectRecord).toCompletionStage());
        return null;
    }

    @Override
    public void stop() {
        this.sinkHandler.stop();
    }
}

