/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.ArgsParser;
import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.bootstrap.LoadState;
import com.navercorp.pinpoint.bootstrap.ModuleBootLoader;
import com.navercorp.pinpoint.bootstrap.ModuleUtils;
import com.navercorp.pinpoint.bootstrap.PinpointStarter;
import com.navercorp.pinpoint.bootstrap.agentdir.AgentDirBaseClassPathResolver;
import com.navercorp.pinpoint.bootstrap.agentdir.AgentDirectory;
import com.navercorp.pinpoint.bootstrap.agentdir.BootDir;
import com.navercorp.pinpoint.bootstrap.agentdir.ClassPathResolver;
import com.navercorp.pinpoint.bootstrap.agentdir.JavaAgentPathResolver;
import java.lang.instrument.Instrumentation;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;

public class PinpointBootStrap {
    private static final BootLogger logger = BootLogger.getLogger(PinpointBootStrap.class);
    private static final LoadState STATE = new LoadState();
    private final String agentArgs;
    private final Instrumentation instrumentation;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        if (PinpointBootStrap.disabled()) {
            if (logger.isWarnEnabled()) {
                logger.warn("PinPoint is disabled via Env/Property.");
            }
            return;
        }
        boolean success = STATE.start();
        if (!success) {
            logger.warn("pinpoint-bootstrap already started. skipping agent loading.");
            return;
        }
        PinpointBootStrap bootStrap = new PinpointBootStrap(agentArgs, instrumentation);
        bootStrap.start();
    }

    private static boolean disabled() {
        String prop = System.getProperty("pinpoint.disable");
        String disable = prop != null ? prop : System.getenv("PINPOINT_DISABLE");
        return disable != null && !disable.equalsIgnoreCase("false");
    }

    private PinpointBootStrap(String agentArgs, Instrumentation instrumentation) {
        this.agentArgs = agentArgs;
        this.instrumentation = Objects.requireNonNull(instrumentation, "instrumentation");
    }

    private void start() {
        logger.info("pinpoint agentArgs:" + this.agentArgs);
        logger.info("PinpointBootStrap.ClassLoader:" + PinpointBootStrap.class.getClassLoader());
        logger.info("ContextClassLoader:" + Thread.currentThread().getContextClassLoader());
        JavaAgentPathResolver javaAgentPathResolver = JavaAgentPathResolver.newJavaAgentPathResolver();
        Path agentPath = javaAgentPathResolver.resolveJavaAgentPath();
        logger.info("JavaAgentPath:" + agentPath);
        if (!agentPath.toFile().exists()) {
            logger.warn("AgentPath not found path:" + agentPath);
        }
        if (Object.class.getClassLoader() != PinpointBootStrap.class.getClassLoader()) {
            logger.warn("Invalid pinpoint-bootstrap.jar:" + this.agentArgs);
            return;
        }
        Map<String, String> agentArgsMap = this.argsToMap(this.agentArgs);
        AgentDirBaseClassPathResolver classPathResolver = new AgentDirBaseClassPathResolver(agentPath);
        AgentDirectory agentDirectory = this.resolveAgentDir(classPathResolver);
        if (agentDirectory == null) {
            logger.warn("Agent Directory Verify fail. skipping agent loading.");
            PinpointBootStrap.logPinpointAgentLoadFail();
            return;
        }
        BootDir bootDir = agentDirectory.getBootDir();
        this.appendToBootstrapClassLoader(this.instrumentation, bootDir);
        ClassLoader parentClassLoader = this.getParentClassLoader();
        ModuleBootLoader moduleBootLoader = this.loadModuleBootLoader(this.instrumentation, parentClassLoader);
        PinpointStarter bootStrap = new PinpointStarter(parentClassLoader, agentArgsMap, agentDirectory, this.instrumentation, moduleBootLoader);
        if (!bootStrap.start()) {
            PinpointBootStrap.logPinpointAgentLoadFail();
        }
    }

    private ModuleBootLoader loadModuleBootLoader(Instrumentation instrumentation, ClassLoader parentClassLoader) {
        if (!ModuleUtils.isModuleSupported()) {
            return null;
        }
        logger.info("java9 module detected");
        logger.info("ModuleBootLoader start");
        ModuleBootLoader moduleBootLoader = new ModuleBootLoader(instrumentation, parentClassLoader);
        moduleBootLoader.loadModuleSupport();
        return moduleBootLoader;
    }

    private AgentDirectory resolveAgentDir(ClassPathResolver classPathResolver) {
        try {
            AgentDirectory agentDir = classPathResolver.resolve();
            return agentDir;
        }
        catch (Exception e) {
            logger.warn("AgentDir resolve fail Caused by:" + e.getMessage(), e);
            return null;
        }
    }

    private ClassLoader getParentClassLoader() {
        ClassLoader classLoader = this.getPinpointBootStrapClassLoader();
        if (classLoader == Object.class.getClassLoader()) {
            logger.info("parentClassLoader:BootStrapClassLoader:" + classLoader);
        } else {
            logger.info("parentClassLoader:" + classLoader);
        }
        return classLoader;
    }

    private ClassLoader getPinpointBootStrapClassLoader() {
        return PinpointBootStrap.class.getClassLoader();
    }

    private Map<String, String> argsToMap(String agentArgs) {
        ArgsParser argsParser = new ArgsParser();
        Map<String, String> agentArgsMap = argsParser.parse(agentArgs);
        if (!agentArgsMap.isEmpty()) {
            logger.info("agentParameter:" + agentArgs);
        }
        return agentArgsMap;
    }

    private void appendToBootstrapClassLoader(Instrumentation instrumentation, BootDir bootDir) {
        List<JarFile> jarFiles = bootDir.openJarFiles();
        for (JarFile jarFile : jarFiles) {
            logger.info("appendToBootstrapClassLoader:" + jarFile.getName());
            instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
        }
    }

    private static void logPinpointAgentLoadFail() {
        String errorLog = "*****************************************************************************\n* Pinpoint Agent load failure\n*****************************************************************************";
        System.err.println("*****************************************************************************\n* Pinpoint Agent load failure\n*****************************************************************************");
    }
}

