/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pulsar.source.connector;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.mq.pulsar.PulsarSourceConfig;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.common.remote.offset.pulsar.PulsarRecordPartition;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSourceConnector
implements Source {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarSourceConnector.class);
    private PulsarSourceConfig sourceConfig;
    private Consumer consumer;

    public Class<? extends Config> configClass() {
        return PulsarSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (PulsarSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (PulsarSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() throws Exception {
        PulsarClient client = PulsarClient.builder().serviceUrl(this.sourceConfig.getConnectorConfig().getServiceUrl()).build();
        this.consumer = client.newConsumer().topic(new String[]{this.sourceConfig.connectorConfig.getTopic()}).subscriptionName(this.sourceConfig.getPubSubConfig().getGroup()).subscribe();
    }

    public void start() throws Exception {
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        try {
            this.consumer.close();
        }
        catch (PulsarClientException e) {
            log.error("close pulsar consumer failed", (Throwable)e);
        }
    }

    public List<ConnectRecord> poll() {
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>();
        try {
            Messages messages = this.consumer.batchReceive();
            for (Object msg : messages) {
                Long timestamp = System.currentTimeMillis();
                Message message = (Message)msg;
                byte[] body = message.getData();
                String bodyStr = new String(body, StandardCharsets.UTF_8);
                PulsarRecordPartition partition = new PulsarRecordPartition();
                partition.setTopic(this.consumer.getTopic());
                partition.setQueueId(Long.valueOf(message.getSequenceId()));
                ConnectRecord connectRecord = new ConnectRecord((RecordPartition)partition, null, timestamp, (Object)bodyStr);
                connectRecord.addExtension("topic", (Object)this.consumer.getTopic());
                connectRecords.add(connectRecord);
            }
            this.consumer.acknowledge(messages);
        }
        catch (PulsarClientException e) {
            log.error("consumer msg from pulsar failed", (Throwable)e);
        }
        return connectRecords;
    }
}

