/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class Property<T> {
    private final String name;
    private final T defaultValue;
    private final String legacyName;

    public static <T> Property<T> named(String name) {
        return new Property<Object>(name, null, null);
    }

    public static <T> Property<T> named(String name, T defaultValue) {
        return new Property<T>(name, defaultValue, null);
    }

    public static <T> Property<T> named(String name, T defaultValue, String legacyName) {
        return new Property<T>(name, defaultValue, legacyName);
    }

    boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    boolean hasLegacyName() {
        return this.legacyName != null;
    }

    public String getFullName(String componentCode) {
        return String.format("%s.%s", componentCode, this.getName());
    }

    public String toString() {
        return this.name;
    }

    @ConstructorProperties(value={"name", "defaultValue", "legacyName"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Property(String name, T defaultValue, String legacyName) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.legacyName = legacyName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Property)) {
            return false;
        }
        Property other = (Property)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        T this$defaultValue = this.getDefaultValue();
        T other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$legacyName = this.getLegacyName();
        String other$legacyName = other.getLegacyName();
        return !(this$legacyName == null ? other$legacyName != null : !this$legacyName.equals(other$legacyName));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Property;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        T $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $legacyName = this.getLegacyName();
        result = result * 59 + ($legacyName == null ? 43 : $legacyName.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLegacyName() {
        return this.legacyName;
    }
}

