/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import io.etcd.jetcd.Auth;
import io.etcd.jetcd.AuthImpl;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.ClientConnectionManager;
import io.etcd.jetcd.CloseableClient;
import io.etcd.jetcd.Cluster;
import io.etcd.jetcd.ClusterImpl;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KVImpl;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.LeaseImpl;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.LockImpl;
import io.etcd.jetcd.Maintenance;
import io.etcd.jetcd.MaintenanceImpl;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.WatchImpl;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

final class ClientImpl
implements Client {
    private final AtomicReference<KV> kvClient;
    private final AtomicReference<Auth> authClient;
    private final AtomicReference<Maintenance> maintenanceClient;
    private final AtomicReference<Cluster> clusterClient;
    private final AtomicReference<Lease> leaseClient;
    private final AtomicReference<Watch> watchClient;
    private final AtomicReference<Lock> lockClient;
    private final ClientBuilder builder;
    private final ClientConnectionManager connectionManager;

    public ClientImpl(ClientBuilder clientBuilder) {
        this.builder = clientBuilder.copy();
        this.kvClient = new AtomicReference();
        this.authClient = new AtomicReference();
        this.maintenanceClient = new AtomicReference();
        this.clusterClient = new AtomicReference();
        this.leaseClient = new AtomicReference();
        this.watchClient = new AtomicReference();
        this.lockClient = new AtomicReference();
        this.connectionManager = new ClientConnectionManager(this.builder);
        if (!clientBuilder.lazyInitialization()) {
            this.connectionManager.getChannel();
        }
    }

    @Override
    public Auth getAuthClient() {
        return this.newClient(this.authClient, AuthImpl::new);
    }

    @Override
    public KV getKVClient() {
        return this.newClient(this.kvClient, KVImpl::new);
    }

    @Override
    public Cluster getClusterClient() {
        return this.newClient(this.clusterClient, ClusterImpl::new);
    }

    @Override
    public Maintenance getMaintenanceClient() {
        return this.newClient(this.maintenanceClient, MaintenanceImpl::new);
    }

    @Override
    public Lease getLeaseClient() {
        return this.newClient(this.leaseClient, LeaseImpl::new);
    }

    @Override
    public Watch getWatchClient() {
        return this.newClient(this.watchClient, WatchImpl::new);
    }

    @Override
    public Lock getLockClient() {
        return this.newClient(this.lockClient, LockImpl::new);
    }

    @Override
    public synchronized void close() {
        Optional.ofNullable(this.authClient.get()).ifPresent(CloseableClient::close);
        Optional.ofNullable(this.kvClient.get()).ifPresent(CloseableClient::close);
        Optional.ofNullable(this.clusterClient.get()).ifPresent(CloseableClient::close);
        Optional.ofNullable(this.maintenanceClient.get()).ifPresent(CloseableClient::close);
        Optional.ofNullable(this.leaseClient.get()).ifPresent(CloseableClient::close);
        Optional.ofNullable(this.watchClient.get()).ifPresent(CloseableClient::close);
        Optional.ofNullable(this.lockClient.get()).ifPresent(CloseableClient::close);
        this.connectionManager.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends CloseableClient> T newClient(AtomicReference<T> reference, Function<ClientConnectionManager, T> factory) {
        CloseableClient client = (CloseableClient)reference.get();
        if (client == null) {
            AtomicReference<T> atomicReference = reference;
            synchronized (atomicReference) {
                client = (CloseableClient)reference.get();
                if (client == null) {
                    client = (CloseableClient)factory.apply(this.connectionManager);
                    reference.lazySet(client);
                }
            }
        }
        return (T)client;
    }
}

