/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.ClientConnectionManager;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.api.WatchCreateRequest;
import io.etcd.jetcd.api.WatchGrpc;
import io.etcd.jetcd.api.WatchRequest;
import io.etcd.jetcd.api.WatchResponse;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdException;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.options.WatchOption;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WatchImpl
implements Watch {
    private static final Logger LOG = LoggerFactory.getLogger(WatchImpl.class);
    private final Object lock = new Object();
    private final ClientConnectionManager connectionManager;
    private final WatchGrpc.WatchStub stub;
    private final ListeningScheduledExecutorService executor;
    private final AtomicBoolean closed;
    private final List<WatcherImpl> watchers;

    WatchImpl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.stub = connectionManager.newStub(WatchGrpc::newStub);
        this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(1));
        this.closed = new AtomicBoolean();
        this.watchers = new ArrayList<WatcherImpl>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Watch.Watcher watch(ByteSequence key, WatchOption option, Watch.Listener listener) {
        WatcherImpl impl;
        if (this.closed.get()) {
            throw EtcdExceptionFactory.newClosedWatchClientException();
        }
        Object object = this.lock;
        synchronized (object) {
            impl = new WatcherImpl(key, option, listener);
            impl.resume();
            this.watchers.add(impl);
        }
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Object object = this.lock;
            synchronized (object) {
                this.executor.shutdownNow();
                this.watchers.forEach(Watch.Watcher::close);
            }
        }
    }

    private final class WatcherImpl
    implements Watch.Watcher,
    StreamObserver<WatchResponse> {
        private final ByteSequence key;
        private final WatchOption option;
        private final Watch.Listener listener;
        private final AtomicBoolean closed;
        private StreamObserver<WatchRequest> stream;
        private long revision;
        private long id;

        WatcherImpl(ByteSequence key, WatchOption option, Watch.Listener listener) {
            this.key = key;
            this.option = option;
            this.listener = listener;
            this.closed = new AtomicBoolean();
            this.stream = null;
            this.id = -1L;
            this.revision = this.option.getRevision();
        }

        void resume() {
            if (this.closed.get() || WatchImpl.this.closed.get()) {
                return;
            }
            if (this.stream == null) {
                this.id = -1L;
                WatchCreateRequest.Builder builder = WatchCreateRequest.newBuilder().setKey(this.key.getByteString()).setPrevKv(this.option.isPrevKV()).setProgressNotify(this.option.isProgressNotify()).setStartRevision(this.revision);
                this.option.getEndKey().map(ByteSequence::getByteString).ifPresent(builder::setRangeEnd);
                if (this.option.isNoDelete()) {
                    builder.addFilters(WatchCreateRequest.FilterType.NODELETE);
                }
                if (this.option.isNoPut()) {
                    builder.addFilters(WatchCreateRequest.FilterType.NOPUT);
                }
                this.stream = WatchImpl.this.stub.watch(this);
                this.stream.onNext((Object)WatchRequest.newBuilder().setCreateRequest(builder).build());
            }
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                if (this.stream != null) {
                    this.stream.onCompleted();
                    this.stream = null;
                }
                this.id = -1L;
                this.listener.onCompleted();
            }
        }

        public void onNext(WatchResponse response) {
            if (response.getCreated()) {
                if (response.getWatchId() == -1L) {
                    this.listener.onError(EtcdExceptionFactory.newEtcdException(ErrorCode.INTERNAL, "etcd server failed to create watch id"));
                    return;
                }
                this.revision = response.getHeader().getRevision();
                this.id = response.getWatchId();
            } else if (response.getCanceled()) {
                String reason = response.getCancelReason();
                EtcdException error = response.getCompactRevision() != 0L ? EtcdExceptionFactory.newCompactedException(response.getCompactRevision()) : (Strings.isNullOrEmpty((String)reason) ? EtcdExceptionFactory.newEtcdException(ErrorCode.OUT_OF_RANGE, "etcdserver: mvcc: required revision is a future revision") : EtcdExceptionFactory.newEtcdException(ErrorCode.FAILED_PRECONDITION, reason));
                this.listener.onError(error);
            } else if (response.getEventsCount() == 0 && this.option.isProgressNotify()) {
                this.listener.onNext(new io.etcd.jetcd.watch.WatchResponse(response));
                this.revision = response.getHeader().getRevision();
            } else if (response.getEventsCount() > 0) {
                this.listener.onNext(new io.etcd.jetcd.watch.WatchResponse(response));
                this.revision = response.getEvents(response.getEventsCount() - 1).getKv().getModRevision() + 1L;
            }
        }

        public void onError(Throwable t) {
            if (this.closed.get() || WatchImpl.this.closed.get()) {
                return;
            }
            Status status = Status.fromThrowable((Throwable)t);
            if (Util.isHaltError(status) || Util.isNoLeaderError(status)) {
                this.listener.onError(EtcdExceptionFactory.toEtcdException(status));
            }
            this.stream.onCompleted();
            this.stream = null;
            Util.addOnFailureLoggingCallback(WatchImpl.this.connectionManager.getExecutorService(), WatchImpl.this.executor.schedule(this::resume, 500L, TimeUnit.MILLISECONDS), LOG, "scheduled resume failed");
        }

        public void onCompleted() {
        }
    }
}

