/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.api.meta.dto.EventMeshDataInfo;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.admin.response.v1.GetRegistryResponse;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.meta.MetaStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/meta")
public class MetaHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaHandler.class);
    private final MetaStorage eventMeshMetaStorage;

    public MetaHandler(MetaStorage eventMeshMetaStorage) {
        this.eventMeshMetaStorage = eventMeshMetaStorage;
    }

    @Override
    protected void get(HttpRequest httpRequest, ChannelHandlerContext ctx) throws IOException {
        try {
            ArrayList<GetRegistryResponse> getRegistryResponseList = new ArrayList<GetRegistryResponse>();
            List<EventMeshDataInfo> eventMeshDataInfos = this.eventMeshMetaStorage.findAllEventMeshInfo();
            for (EventMeshDataInfo eventMeshDataInfo : eventMeshDataInfos) {
                GetRegistryResponse getRegistryResponse = new GetRegistryResponse(eventMeshDataInfo.getEventMeshClusterName(), eventMeshDataInfo.getEventMeshName(), eventMeshDataInfo.getEndpoint(), eventMeshDataInfo.getLastUpdateTimestamp(), eventMeshDataInfo.getMetadata().toString());
                getRegistryResponseList.add(getRegistryResponse);
            }
            getRegistryResponseList.sort(Comparator.comparing(GetRegistryResponse::getEventMeshClusterName));
            String result = JsonUtils.toJSONString(getRegistryResponseList);
            this.writeJson(ctx, result);
        }
        catch (NullPointerException e) {
            String result = JsonUtils.toJSONString(new ArrayList());
            this.writeJson(ctx, result);
        }
    }
}

