/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEventBatch;
import org.apache.eventmesh.common.protocol.grpc.common.BatchEventMeshCloudEventWrapper;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.processor.AbstractPublishBatchCloudEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.ProducerManager;
import org.apache.eventmesh.runtime.core.protocol.producer.SendMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPublishCloudEventProcessor
extends AbstractPublishBatchCloudEventProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchPublishCloudEventProcessor.class);

    public BatchPublishCloudEventProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        super(eventMeshGrpcServer, eventMeshGrpcServer.getAcl());
    }

    @Override
    public void handleCloudEvent(CloudEventBatch cloudEventBatch, EventEmitter<CloudEvent> emitter) throws Exception {
        CloudEvent cloudEvent = cloudEventBatch.getEvents(0);
        final String topic = EventMeshCloudEventUtils.getSubject((CloudEvent)cloudEvent);
        String producerGroup = EventMeshCloudEventUtils.getProducerGroup((CloudEvent)cloudEvent);
        String protocolType = EventMeshCloudEventUtils.getProtocolType((CloudEvent)cloudEvent);
        ProtocolAdaptor grpcCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        List cloudEvents = grpcCommandProtocolAdaptor.toBatchCloudEvent((ProtocolTransportObject)new BatchEventMeshCloudEventWrapper(cloudEventBatch));
        for (io.cloudevents.CloudEvent event : cloudEvents) {
            final String seqNum = event.getId();
            final String uniqueId = event.getExtension("uniqueid") == null ? "" : event.getExtension("uniqueid").toString();
            ProducerManager producerManager = this.eventMeshGrpcServer.getProducerManager();
            EventMeshProducer eventMeshProducer = producerManager.getEventMeshProducer(producerGroup);
            SendMessageContext sendMessageContext = new SendMessageContext(seqNum, event, eventMeshProducer, this.eventMeshGrpcServer);
            this.eventMeshGrpcServer.getEventMeshGrpcMetricsManager().recordSendMsgToQueue();
            final long startTime = System.currentTimeMillis();
            eventMeshProducer.send(sendMessageContext, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    long endTime = System.currentTimeMillis();
                    log.info("message|eventMesh2mq|REQ|BatchSend|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, seqNum, uniqueId});
                }

                public void onException(OnExceptionContext context) {
                    long endTime = System.currentTimeMillis();
                    log.error("message|eventMesh2mq|REQ|BatchSend|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, topic, seqNum, uniqueId, context.getException()});
                }
            });
        }
        ServiceUtils.sendResponseCompleted(StatusCode.SUCCESS, "batch publish success", emitter);
    }
}

