/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.push;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.http.common.ClientRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.WebhookTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.AbstractPushRequest;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.HandleMsgContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookPushRequest
extends AbstractPushRequest {
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private static final Logger CMD_LOGGER = LoggerFactory.getLogger((String)"cmd");
    private final Map<String, List<String>> urls;
    private final List<String> totalUrls;
    private final int startIdx;
    private final SubscriptionMode subscriptionMode;

    public WebhookPushRequest(HandleMsgContext handleMsgContext, Map<String, Set<AbstractPushRequest>> waitingRequests) {
        super(handleMsgContext, waitingRequests);
        WebhookTopicConfig topicConfig = (WebhookTopicConfig)handleMsgContext.getConsumeTopicConfig();
        this.subscriptionMode = topicConfig.getSubscriptionMode();
        this.urls = topicConfig.getIdcUrls();
        this.totalUrls = topicConfig.getTotalUrls();
        this.startIdx = RandomUtils.nextInt((int)0, (int)this.totalUrls.size());
    }

    @Override
    public void tryPushRequest() {
        if (this.eventMeshCloudEvent == null) {
            return;
        }
        List<String> selectedPushUrls = this.getUrl();
        for (String selectedPushUrl : selectedPushUrls) {
            this.lastPushTime = System.currentTimeMillis();
            HttpPost builder = new HttpPost(selectedPushUrl);
            String requestCode = String.valueOf(RequestCode.HTTP_PUSH_CLIENT_ASYNC.getRequestCode());
            builder.addHeader("code", requestCode);
            builder.addHeader("language", "JAVA");
            builder.addHeader("version", ProtocolVersion.V1.getVersion());
            builder.addHeader("eventmeshcluster", this.eventMeshGrpcConfiguration.getEventMeshCluster());
            builder.addHeader("eventmeship", this.eventMeshGrpcConfiguration.getEventMeshIp());
            builder.addHeader("eventmeshenv", this.eventMeshGrpcConfiguration.getEventMeshEnv());
            builder.addHeader("eventmeshidc", this.eventMeshGrpcConfiguration.getEventMeshIDC());
            builder.addHeader("protocoltype", EventMeshCloudEventUtils.getProtocolType((CloudEvent)this.eventMeshCloudEvent));
            builder.addHeader("protocoldesc", EventMeshCloudEventUtils.getProtocolDesc((CloudEvent)this.eventMeshCloudEvent));
            builder.addHeader("protocolversion", EventMeshCloudEventUtils.getProtocolVersion((CloudEvent)this.eventMeshCloudEvent));
            builder.addHeader("contenttype", EventMeshCloudEventUtils.getContentType((CloudEvent)this.eventMeshCloudEvent, (String)"application/cloudevents+json"));
            ArrayList<BasicNameValuePair> body = new ArrayList<BasicNameValuePair>();
            body.add(new BasicNameValuePair("content", EventMeshCloudEventUtils.getDataContent((CloudEvent)this.eventMeshCloudEvent)));
            body.add(new BasicNameValuePair("bizseqno", EventMeshCloudEventUtils.getSeqNum((CloudEvent)this.eventMeshCloudEvent)));
            body.add(new BasicNameValuePair("uniqueId", EventMeshCloudEventUtils.getUniqueId((CloudEvent)this.eventMeshCloudEvent)));
            body.add(new BasicNameValuePair("randomNo", this.handleMsgContext.getMsgRandomNo()));
            body.add(new BasicNameValuePair("topic", EventMeshCloudEventUtils.getSubject((CloudEvent)this.eventMeshCloudEvent)));
            body.add(new BasicNameValuePair("extFields", JsonUtils.toJSONString((Object)EventMeshCloudEventUtils.getAttributes((CloudEvent)this.eventMeshCloudEvent))));
            this.eventMeshCloudEvent = CloudEvent.newBuilder((CloudEvent)this.eventMeshCloudEvent).putAttributes("reqeventmesh2ctimestamp", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(String.valueOf(this.lastPushTime)).build()).build();
            builder.setEntity((HttpEntity)new UrlEncodedFormEntity(body, StandardCharsets.UTF_8));
            this.addToWaitingMap(this);
            CMD_LOGGER.info("cmd={}|eventMesh2client|from={}|to={}", new Object[]{requestCode, IPUtils.getLocalAddress(), selectedPushUrl});
            try {
                this.eventMeshGrpcServer.getHttpClient().execute((HttpUriRequest)builder, this.handleResponse(selectedPushUrl));
                MESSAGE_LOGGER.info("message|eventMesh2client|url={}|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{selectedPushUrl, EventMeshCloudEventUtils.getSubject((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getSeqNum((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getUniqueId((CloudEvent)this.eventMeshCloudEvent)});
            }
            catch (IOException e) {
                long cost = System.currentTimeMillis() - this.lastPushTime;
                MESSAGE_LOGGER.error("message|eventMesh2client|exception={} |emitter|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{e.getMessage(), EventMeshCloudEventUtils.getSubject((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getSeqNum((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getUniqueId((CloudEvent)this.eventMeshCloudEvent), cost, e});
                this.removeWaitingMap(this);
                this.delayRetry();
            }
        }
    }

    public String toString() {
        return "asyncPushRequest={bizSeqNo=" + EventMeshCloudEventUtils.getSeqNum((CloudEvent)this.eventMeshCloudEvent) + ",startIdx=" + this.startIdx + ",retryTimes=" + this.retryTimes + ",uniqueId=" + EventMeshCloudEventUtils.getUniqueId((CloudEvent)this.eventMeshCloudEvent) + ",executeTime=" + DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + ",lastPushTime=" + DateFormatUtils.format((long)this.lastPushTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + "}";
    }

    private ResponseHandler<Object> handleResponse(String selectedPushUrl) {
        return response -> {
            this.removeWaitingMap(this);
            long cost = System.currentTimeMillis() - this.lastPushTime;
            if (response.getStatusLine().getStatusCode() != 200) {
                MESSAGE_LOGGER.info("message|eventMesh2client|exception|url={}|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{selectedPushUrl, EventMeshCloudEventUtils.getSubject((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getSeqNum((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getUniqueId((CloudEvent)this.eventMeshCloudEvent), cost});
                this.delayRetry();
            } else {
                String res = "";
                try {
                    res = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName(EventMeshConstants.DEFAULT_CHARSET));
                }
                catch (IOException e) {
                    this.complete();
                    return new Object();
                }
                ClientRetCode result = this.processResponseContent(res, selectedPushUrl);
                MESSAGE_LOGGER.info("message|eventMesh2client|{}|url={}|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{result, selectedPushUrl, EventMeshCloudEventUtils.getSubject((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getSeqNum((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getUniqueId((CloudEvent)this.eventMeshCloudEvent), cost});
                switch (result) {
                    case OK: 
                    case FAIL: {
                        this.complete();
                        break;
                    }
                    case RETRY: 
                    case NOLISTEN: {
                        this.delayRetry();
                        break;
                    }
                }
            }
            return new Object();
        };
    }

    private ClientRetCode processResponseContent(String content, String selectedPushUrl) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return ClientRetCode.FAIL;
        }
        try {
            Map ret = (Map)JsonUtils.parseTypeReferenceObject((String)content, (TypeReference)new TypeReference<Map<String, Object>>(){});
            Integer retCode = (Integer)Objects.requireNonNull(ret).get("retCode");
            if (retCode != null && ClientRetCode.contains((Integer)retCode)) {
                return ClientRetCode.get((Integer)retCode);
            }
            return ClientRetCode.FAIL;
        }
        catch (Exception e) {
            MESSAGE_LOGGER.warn("url:{}, bizSeqno:{}, uniqueId:{},  httpResponse:{}", new Object[]{selectedPushUrl, EventMeshCloudEventUtils.getSeqNum((CloudEvent)this.eventMeshCloudEvent), EventMeshCloudEventUtils.getUniqueId((CloudEvent)this.eventMeshCloudEvent), content});
            return ClientRetCode.FAIL;
        }
    }

    private List<String> getUrl() {
        List localIdcUrl = (List)MapUtils.getObject(this.urls, (Object)this.eventMeshGrpcConfiguration.getEventMeshIDC(), null);
        if (CollectionUtils.isNotEmpty((Collection)localIdcUrl)) {
            return this.getStringList(localIdcUrl);
        }
        if (CollectionUtils.isNotEmpty(this.totalUrls)) {
            return this.getStringList(this.totalUrls);
        }
        MESSAGE_LOGGER.error("No event emitters from subscriber, no message returning.");
        return Collections.emptyList();
    }

    private List<String> getStringList(List<String> stringList) {
        switch (this.subscriptionMode) {
            case CLUSTERING: {
                return Collections.singletonList(stringList.get((this.startIdx + this.retryTimes) % stringList.size()));
            }
            case BROADCASTING: {
                return stringList;
            }
        }
        MESSAGE_LOGGER.error("Invalid Subscription Mode, no message returning back to subscriber.");
        return Collections.emptyList();
    }
}

