/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session;

import io.cloudevents.CloudEvent;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.SessionContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.SessionState;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.DownStreamMsgContext;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push.SessionPusher;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.EventMeshTcpSendResult;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.send.SessionSender;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    protected static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private static final Logger SUBSCRIB_LOGGER = LoggerFactory.getLogger((String)"subscribeLogger");
    private UserAgent client;
    private InetSocketAddress remoteAddress;
    protected ChannelHandlerContext context;
    private WeakReference<ClientGroupWrapper> clientGroupWrapper;
    private EventMeshTCPConfiguration eventMeshTCPConfiguration;
    private SessionPusher pusher;
    private SessionSender sender;
    private final long createTime = System.currentTimeMillis();
    private long lastHeartbeatTime = System.currentTimeMillis();
    private long isolateTime;
    private SessionContext sessionContext = new SessionContext(this);
    private volatile boolean listenRspSend;
    private final ReentrantLock listenRspLock = new ReentrantLock();
    private String listenRequestSeq;
    protected SessionState sessionState = SessionState.CREATED;
    private String sessionId = UUID.randomUUID().toString();

    public void notifyHeartbeat(long heartbeatTime) throws Exception {
        this.lastHeartbeatTime = heartbeatTime;
    }

    public void subscribe(List<SubscriptionItem> items) throws Exception {
        for (SubscriptionItem item : items) {
            this.sessionContext.getSubscribeTopics().putIfAbsent(item.getTopic(), item);
            Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).subscribe(item);
            Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).getMqProducerWrapper().getMeshMQProducer().checkTopicExist(item.getTopic());
            Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).addSubscription(item, this);
            SUBSCRIB_LOGGER.info("subscribe|succeed|topic={}|user={}", (Object)item.getTopic(), (Object)this.client);
        }
    }

    public void unsubscribe(List<SubscriptionItem> items) throws Exception {
        for (SubscriptionItem item : items) {
            this.sessionContext.getSubscribeTopics().remove(item.getTopic());
            Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).removeSubscription(item, this);
            if (Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).hasSubscription(item.getTopic())) continue;
            Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).unsubscribe(item);
            SUBSCRIB_LOGGER.info("unSubscribe|succeed|topic={}|lastUser={}", (Object)item.getTopic(), (Object)this.client);
        }
    }

    public EventMeshTcpSendResult upstreamMsg(Header header, CloudEvent event, SendCallback sendCallback, long startTime, long taskExecuteTime) {
        String topic = event.getSubject();
        this.sessionContext.getSendTopics().putIfAbsent(topic, topic);
        return this.sender.send(header, event, sendCallback, startTime, taskExecuteTime);
    }

    public void downstreamMsg(DownStreamMsgContext downStreamMsgContext) {
        long currTime = System.currentTimeMillis();
        this.trySendListenResponse(new Header(Command.LISTEN_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), "succeed", this.getListenRequestSeq()), currTime, currTime);
        this.pusher.push(downStreamMsgContext);
    }

    public boolean isIsolated() {
        return System.currentTimeMillis() < this.isolateTime;
    }

    public void write2Client(final Package pkg) {
        try {
            if (SessionState.CLOSED == this.sessionState) {
                return;
            }
            this.context.writeAndFlush((Object)pkg).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        MESSAGE_LOGGER.error("write2Client fail, pkg[{}] session[{}]", (Object)pkg, (Object)this);
                    } else {
                        Objects.requireNonNull((ClientGroupWrapper)Session.this.clientGroupWrapper.get()).getEventMeshTcpMetricsManager().eventMesh2clientMsgNumIncrement(IPUtils.parseChannelRemoteAddr((Channel)future.channel()));
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("exception while write2Client", (Throwable)e);
        }
    }

    public String toString() {
        HashMap<String, Object> sessionJson = new HashMap<String, Object>();
        sessionJson.put("sysId", Objects.requireNonNull((ClientGroupWrapper)this.clientGroupWrapper.get()).getSysId());
        sessionJson.put("remoteAddr", RemotingHelper.parseSocketAddressAddr(this.remoteAddress));
        sessionJson.put("client", this.client);
        sessionJson.put("sessionState", (Object)this.sessionState);
        sessionJson.put("sessionContext", this.sessionContext);
        sessionJson.put("pusher", this.pusher);
        sessionJson.put("sender", this.sender);
        sessionJson.put("createTime", DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        sessionJson.put("lastHeartbeatTime", DateFormatUtils.format((long)this.lastHeartbeatTime, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        return JsonUtils.toJSONString(sessionJson);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        if (!Objects.equals(this.client, session.client)) {
            return false;
        }
        if (!Objects.equals(this.context, session.context)) {
            return false;
        }
        return Objects.equals((Object)this.sessionState, (Object)session.sessionState);
    }

    public int hashCode() {
        int result = 1001;
        if (this.client != null) {
            result += 31 * result + Objects.hash(this.client);
        }
        if (this.context != null) {
            result += 31 * result + Objects.hash(this.context);
        }
        if (this.sessionState != null) {
            result += 31 * result + Objects.hash(new Object[]{this.sessionState});
        }
        return result;
    }

    public Session(UserAgent client, ChannelHandlerContext context, EventMeshTCPConfiguration eventMeshTCPConfiguration) {
        this.client = client;
        this.context = context;
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
        this.remoteAddress = (InetSocketAddress)context.channel().remoteAddress();
        this.sender = new SessionSender(this);
        this.pusher = new SessionPusher(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trySendListenResponse(Header header, long startTime, long taskExecuteTime) {
        if (!this.listenRspSend && this.listenRspLock.tryLock()) {
            try {
                if (this.listenRspSend) {
                    return;
                }
                if (header == null) {
                    header = new Header(Command.LISTEN_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), "succeed", null);
                }
                Package msg = new Package();
                msg.setHeader(header);
                Utils.writeAndFlush(msg, startTime, taskExecuteTime, this.context, this);
                this.listenRspSend = true;
            }
            finally {
                this.listenRspLock.unlock();
            }
        }
    }

    public boolean isAvailable(String topic) {
        if (SessionState.CLOSED == this.sessionState) {
            log.warn("session is not available because session has been closed,topic:{},client:{}", (Object)topic, (Object)this.client);
            return false;
        }
        if (!this.sessionContext.getSubscribeTopics().containsKey(topic)) {
            log.warn("session is not available because session has not subscribe topic:{},client:{}", (Object)topic, (Object)this.client);
            return false;
        }
        return true;
    }

    public boolean isRunning() {
        if (SessionState.RUNNING != this.sessionState) {
            log.warn("session is not running, state:{} client:{}", (Object)this.sessionState, (Object)this.client);
            return false;
        }
        return true;
    }

    @Generated
    public void setClient(UserAgent client) {
        this.client = client;
    }

    @Generated
    public UserAgent getClient() {
        return this.client;
    }

    @Generated
    public void setRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Generated
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Generated
    public void setContext(ChannelHandlerContext context) {
        this.context = context;
    }

    @Generated
    public ChannelHandlerContext getContext() {
        return this.context;
    }

    @Generated
    public void setClientGroupWrapper(WeakReference<ClientGroupWrapper> clientGroupWrapper) {
        this.clientGroupWrapper = clientGroupWrapper;
    }

    @Generated
    public WeakReference<ClientGroupWrapper> getClientGroupWrapper() {
        return this.clientGroupWrapper;
    }

    @Generated
    public void setEventMeshTCPConfiguration(EventMeshTCPConfiguration eventMeshTCPConfiguration) {
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
    }

    @Generated
    public EventMeshTCPConfiguration getEventMeshTCPConfiguration() {
        return this.eventMeshTCPConfiguration;
    }

    @Generated
    public void setPusher(SessionPusher pusher) {
        this.pusher = pusher;
    }

    @Generated
    public SessionPusher getPusher() {
        return this.pusher;
    }

    @Generated
    public void setSender(SessionSender sender) {
        this.sender = sender;
    }

    @Generated
    public SessionSender getSender() {
        return this.sender;
    }

    @Generated
    public void setLastHeartbeatTime(long lastHeartbeatTime) {
        this.lastHeartbeatTime = lastHeartbeatTime;
    }

    @Generated
    public long getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    @Generated
    public void setIsolateTime(long isolateTime) {
        this.isolateTime = isolateTime;
    }

    @Generated
    public long getIsolateTime() {
        return this.isolateTime;
    }

    @Generated
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @Generated
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Generated
    public void setListenRequestSeq(String listenRequestSeq) {
        this.listenRequestSeq = listenRequestSeq;
    }

    @Generated
    public String getListenRequestSeq() {
        return this.listenRequestSeq;
    }

    @Generated
    public void setSessionState(SessionState sessionState) {
        this.sessionState = sessionState;
    }

    @Generated
    public SessionState getSessionState() {
        return this.sessionState;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }
}

