/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.session.push;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.runtime.core.plugin.MQConsumerWrapper;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAckContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientAckContext.class);
    private String seq;
    private AbstractContext context;
    private long createTime;
    private long expireTime;
    private List<CloudEvent> events;
    private final MQConsumerWrapper consumer;

    public ClientAckContext(String seq, AbstractContext context, List<CloudEvent> events, MQConsumerWrapper consumer) {
        this.seq = seq;
        this.context = context;
        this.events = events;
        this.consumer = consumer;
        this.createTime = System.currentTimeMillis();
        String ttlStr = events.get(0).getExtension("ttl") == null ? "" : Objects.requireNonNull(events.get(0).getExtension("ttl")).toString();
        long ttl = StringUtils.isNumeric((CharSequence)ttlStr) ? Long.parseLong(ttlStr) : 3000L;
        this.expireTime = System.currentTimeMillis() + ttl;
    }

    public boolean isExpire() {
        return System.currentTimeMillis() >= this.expireTime;
    }

    public String getSeq() {
        return this.seq;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    public AbstractContext getContext() {
        return this.context;
    }

    public void setContext(AbstractContext context) {
        this.context = context;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public List<CloudEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<CloudEvent> events) {
        this.events = events;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public MQConsumerWrapper getConsumer() {
        return this.consumer;
    }

    public void ackMsg() {
        if (this.consumer != null && this.context != null && this.events != null) {
            this.consumer.updateOffset(this.events, this.context);
            log.info("ackMsg topic:{}, bizSeq:{}", (Object)this.events.get(0).getSubject(), (Object)EventMeshUtil.getMessageBizSeq(this.events.get(0)));
        } else {
            log.warn("ackMsg failed,consumer is null:{}, context is null:{} , msgs is null:{}", new Object[]{this.consumer == null, this.context == null, this.events == null});
        }
    }

    public String toString() {
        return "ClientAckContext{,seq=" + this.seq + ",topic=" + (CollectionUtils.size(this.events) > 0 ? this.events.get(0).getSubject() : null) + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + ",expireTime=" + DateFormatUtils.format((long)this.expireTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + '}';
    }
}

