/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.tcp;

import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.metrics.tcp.TcpMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpMetricsCalculator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TcpMetricsCalculator.class);
    private static final int period = 30000;
    private static int PRINT_THREADPOOLSTATE_INTERVAL = 1;
    private final EventMeshTCPServer eventMeshTCPServer;
    private final TcpMetrics tcpMetrics;
    private ScheduledFuture<?> monitorTpsTask;
    private ScheduledExecutorService scheduler;

    public TcpMetricsCalculator(EventMeshTCPServer eventMeshTCPServer, TcpMetrics tcpMetrics) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.tcpMetrics = tcpMetrics;
        this.scheduler = ThreadPoolFactory.createScheduledExecutor((int)2, (ThreadFactory)new EventMeshThreadFactory("EventMesh-TcpMetricsCalculator-scheduler", true));
    }

    public void start() {
        int delay = 60000;
        this.monitorTpsTask = this.scheduler.scheduleAtFixedRate(() -> {
            long msgNum = this.tcpMetrics.client2eventMeshMsgNum();
            this.tcpMetrics.resetClient2EventMeshMsgNum();
            this.tcpMetrics.setClient2eventMeshTPS(new BigDecimal(1000L * msgNum).divide(new BigDecimal(30000), 2, 4).doubleValue());
            msgNum = this.tcpMetrics.eventMesh2clientMsgNum();
            this.tcpMetrics.resetEventMesh2ClientMsgNum();
            this.tcpMetrics.setEventMesh2clientTPS(new BigDecimal(1000L * msgNum).divide(new BigDecimal(30000), 2, 4).doubleValue());
            msgNum = this.tcpMetrics.eventMesh2mqMsgNum();
            this.tcpMetrics.resetEventMesh2mqMsgNum();
            this.tcpMetrics.setEventMesh2mqTPS(new BigDecimal(1000L * msgNum).divide(new BigDecimal(30000), 2, 4).doubleValue());
            msgNum = this.tcpMetrics.mq2eventMeshMsgNum();
            this.tcpMetrics.resetMq2eventMeshMsgNum();
            this.tcpMetrics.setMq2eventMeshTPS(new BigDecimal(1000L * msgNum).divide(new BigDecimal(30000), 2, 4).doubleValue());
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = this.eventMeshTCPServer.getClientSessionGroupMapping().getSessionMap();
            Iterator<Session> sessionIterator = sessionMap.values().iterator();
            HashSet topicSet = new HashSet();
            while (sessionIterator.hasNext()) {
                Session session = sessionIterator.next();
                AtomicLong deliveredMsgsCount = session.getPusher().getDeliveredMsgsCount();
                AtomicLong deliveredFailCount = session.getPusher().getDeliverFailMsgsCount();
                int unAckMsgsCount = session.getPusher().getTotalUnackMsgs();
                int sendTopics = session.getSessionContext().getSendTopics().size();
                int subscribeTopics = session.getSessionContext().getSubscribeTopics().size();
                log.info("session|deliveredFailCount={}|deliveredMsgsCount={}|unAckMsgsCount={}|sendTopics={}|subscribeTopics={}|user={}", new Object[]{deliveredFailCount.longValue(), deliveredMsgsCount.longValue(), unAckMsgsCount, sendTopics, subscribeTopics, session.getClient()});
                topicSet.addAll(session.getSessionContext().getSubscribeTopics().keySet());
            }
            this.tcpMetrics.setSubTopicNum(topicSet.size());
            this.tcpMetrics.setAllConnections(this.eventMeshTCPServer.getTcpConnectionHandler().getConnectionCount());
            this.printAppLogger(this.tcpMetrics);
        }, delay, 30000L, TimeUnit.MILLISECONDS);
    }

    private void printAppLogger(TcpMetrics tcpSummaryMetrics) {
        log.info("===========================================TCP SERVER METRICS==================================================");
        log.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "client2eventMeshTPS", tcpSummaryMetrics.getClient2eventMeshTPS()});
        log.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "eventMesh2mqTPS", tcpSummaryMetrics.getEventMesh2mqTPS()});
        log.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "mq2eventMeshTPS", tcpSummaryMetrics.getMq2eventMeshTPS()});
        log.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "eventMesh2clientTPS", tcpSummaryMetrics.getEventMesh2clientTPS()});
        log.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "allTPS", tcpSummaryMetrics.getAllTPS()});
        log.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "connection", tcpSummaryMetrics.getAllConnectionsGauge()});
        log.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "subTopicNum", tcpSummaryMetrics.getSubTopicNum()});
    }

    public void shutdown() {
        this.monitorTpsTask.cancel(true);
    }
}

