/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class HttpTinyClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpGet(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        String encodedContent = HttpTinyClient.encodingParams(paramValues, encoding);
        url = url + (encodedContent == null ? "" : "?" + encodedContent);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout((int)readTimeoutMs);
            conn.setReadTimeout((int)readTimeoutMs);
            HttpTinyClient.setHeaders(conn, headers, encoding);
            conn.connect();
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IOUtils.toString((InputStream)conn.getInputStream(), (String)encoding) : IOUtils.toString((InputStream)conn.getErrorStream(), (String)encoding);
            HttpResult httpResult = new HttpResult(respCode, resp);
            return httpResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static String encodingParams(Collection<String> paramValues, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (paramValues == null) {
            return null;
        }
        Iterator<String> iter = paramValues.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append("=");
            sb.append(URLEncoder.encode(iter.next(), encoding));
            if (!iter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    private static void setHeaders(HttpURLConnection conn, Collection<String> headers, String encoding) {
        if (headers != null) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + encoding);
        String ts = String.valueOf(System.currentTimeMillis());
        conn.addRequestProperty("Metaq-Client-RequestTS", ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpPost(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        String encodedContent = HttpTinyClient.encodingParams(paramValues, encoding);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(3000);
            conn.setReadTimeout((int)readTimeoutMs);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            HttpTinyClient.setHeaders(conn, headers, encoding);
            conn.getOutputStream().write(Objects.requireNonNull(encodedContent).getBytes(StandardCharsets.UTF_8));
            int respCode = conn.getResponseCode();
            String resp = 200 == respCode ? IOUtils.toString((InputStream)conn.getInputStream(), (String)encoding) : IOUtils.toString((InputStream)conn.getErrorStream(), (String)encoding);
            HttpResult httpResult = new HttpResult(respCode, resp);
            return httpResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static class HttpResult {
        private final transient int code;
        private final transient String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.content = content;
        }

        public int getCode() {
            return this.code;
        }

        public String getContent() {
            return this.content;
        }
    }
}

