/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import jodd.bean.BeanCopy;
import jodd.bean.BeanUtil;
import jodd.introspector.ClassIntrospector;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.FieldProxy;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.redisson.RedissonKeys;
import org.redisson.RedissonMap;
import org.redisson.RedissonObject;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonSetMultimap;
import org.redisson.api.BatchResult;
import org.redisson.api.RCascadeType;
import org.redisson.api.RDeque;
import org.redisson.api.RExpirable;
import org.redisson.api.RExpirableAsync;
import org.redisson.api.RFuture;
import org.redisson.api.RList;
import org.redisson.api.RLiveObject;
import org.redisson.api.RLiveObjectService;
import org.redisson.api.RMap;
import org.redisson.api.RMapAsync;
import org.redisson.api.RObject;
import org.redisson.api.RObjectAsync;
import org.redisson.api.RQueue;
import org.redisson.api.RSet;
import org.redisson.api.RSortedSet;
import org.redisson.api.annotation.RCascade;
import org.redisson.api.annotation.REntity;
import org.redisson.api.annotation.RFieldAccessor;
import org.redisson.api.annotation.RId;
import org.redisson.api.annotation.RIndex;
import org.redisson.api.condition.Condition;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.ListScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.liveobject.LiveObjectSearch;
import org.redisson.liveobject.LiveObjectTemplate;
import org.redisson.liveobject.core.AccessorInterceptor;
import org.redisson.liveobject.core.FieldAccessorInterceptor;
import org.redisson.liveobject.core.LiveObjectInterceptor;
import org.redisson.liveobject.core.RMapInterceptor;
import org.redisson.liveobject.misc.AdvBeanCopy;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.liveobject.misc.Introspectior;
import org.redisson.liveobject.resolver.MapResolver;
import org.redisson.liveobject.resolver.NamingScheme;
import org.redisson.liveobject.resolver.RIdResolver;

public class RedissonLiveObjectService
implements RLiveObjectService {
    private static final ConcurrentMap<Class<? extends RIdResolver<?>>, RIdResolver<?>> PROVIDER_CACHE = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Class<?>> classCache;
    private final CommandAsyncExecutor commandExecutor;
    private final LiveObjectSearch seachEngine;
    private final MapResolver mapResolver;

    public RedissonLiveObjectService(ConcurrentMap<Class<?>, Class<?>> classCache, CommandAsyncExecutor commandExecutor) {
        this.classCache = classCache;
        this.commandExecutor = commandExecutor;
        this.seachEngine = new LiveObjectSearch(commandExecutor);
        this.mapResolver = commandExecutor.getServiceManager().getLiveObjectMapResolver();
    }

    private void addExpireListener(CommandAsyncExecutor commandExecutor) {
        if (commandExecutor.getServiceManager().getLiveObjectLatch().compareAndSet(false, true)) {
            String pp = "__keyspace@" + commandExecutor.getServiceManager().getConfig().getDatabase() + "__:redisson_live_object:*";
            String prefix = pp.replace(":redisson_live_object:*", "");
            RedissonPatternTopic topic = new RedissonPatternTopic(StringCodec.INSTANCE, commandExecutor, pp);
            topic.addListenerAsync(String.class, (pattern, channel, msg) -> {
                if (!msg.equals("expired")) {
                    return;
                }
                String name = channel.toString().replace(prefix, "");
                Class<?> entity = this.resolveEntity(name);
                if (entity == null) {
                    return;
                }
                NamingScheme scheme = commandExecutor.getObjectBuilder().getNamingScheme(entity);
                Object id = scheme.resolveId(name);
                this.deleteExpired(id, entity);
            });
        }
    }

    private Class<?> resolveEntity(String name) {
        String className = name.substring(name.lastIndexOf(":") + 1);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return this.classCache.keySet().stream().filter(c -> c.getName().equals(className)).findAny().orElse(null);
        }
    }

    private RMap<String, Object> getMap(Object proxied) {
        return this.asLiveObject(proxied).getLiveObjectLiveMap();
    }

    private <T> Object generateId(Class<T> entityClass, String idFieldName) throws NoSuchFieldException {
        RId annotation = ClassUtils.getDeclaredField(entityClass, idFieldName).getAnnotation(RId.class);
        RIdResolver<T> resolver = this.getResolver(annotation.generator());
        Object id = resolver.resolve(entityClass, annotation, idFieldName, this.commandExecutor);
        return id;
    }

    private RIdResolver<?> getResolver(Class<? extends RIdResolver<?>> resolverClass) {
        if (!PROVIDER_CACHE.containsKey(resolverClass)) {
            try {
                PROVIDER_CACHE.putIfAbsent(resolverClass, resolverClass.newInstance());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return (RIdResolver)PROVIDER_CACHE.get(resolverClass);
    }

    public <T> T createLiveObject(Class<T> entityClass, Object id) {
        this.registerClass(entityClass);
        Class proxyClass = (Class)this.classCache.get(entityClass);
        return this.instantiateLiveObject(proxyClass, id);
    }

    private <T> T createLiveObject(Class<T> entityClass, Object id, CommandAsyncExecutor commandExecutor, Map<Class<?>, Class<?>> classCache) {
        Class<Object> proxyClass = classCache.get(entityClass);
        if (proxyClass == null) {
            this.validateClass(entityClass);
            proxyClass = this.createProxy(entityClass, commandExecutor);
            classCache.put(entityClass, proxyClass);
        }
        return (T)this.instantiateLiveObject(proxyClass, id);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id) {
        this.addExpireListener(this.commandExecutor);
        T proxied = this.createLiveObject(entityClass, id);
        if (this.asLiveObject(proxied).isExists()) {
            return proxied;
        }
        return null;
    }

    @Override
    public <T> Collection<T> find(Class<T> entityClass, Condition condition) {
        this.addExpireListener(this.commandExecutor);
        Set<Object> ids = this.seachEngine.find(entityClass, condition);
        return ids.stream().map(id -> this.createLiveObject(entityClass, id)).collect(Collectors.toList());
    }

    @Override
    public long count(Class<?> entityClass, Condition condition) {
        this.addExpireListener(this.commandExecutor);
        Set<Object> ids = this.seachEngine.find(entityClass, condition);
        return ids.size();
    }

    @Override
    public <T> T attach(T detachedObject) {
        this.addExpireListener(this.commandExecutor);
        this.validateDetached(detachedObject);
        Class<?> entityClass = detachedObject.getClass();
        String idFieldName = this.getRIdFieldName(detachedObject.getClass());
        Object id = ClassUtils.getField(detachedObject, idFieldName);
        return (T)this.createLiveObject(entityClass, id);
    }

    private <T> T attach(T detachedObject, CommandAsyncExecutor commandExecutor, Map<Class<?>, Class<?>> classCache) {
        this.validateDetached(detachedObject);
        Class<?> entityClass = detachedObject.getClass();
        String idFieldName = this.getRIdFieldName(detachedObject.getClass());
        Object id = ClassUtils.getField(detachedObject, idFieldName);
        return (T)this.createLiveObject(entityClass, id, commandExecutor, classCache);
    }

    @Override
    public <T> T merge(T detachedObject) {
        HashMap<Object, Object> alreadyPersisted = new HashMap<Object, Object>();
        return this.persist(detachedObject, alreadyPersisted, RCascadeType.MERGE);
    }

    @Override
    public <T> T persist(T detachedObject) {
        HashMap<Object, Object> alreadyPersisted = new HashMap<Object, Object>();
        return this.persist(detachedObject, alreadyPersisted, RCascadeType.PERSIST);
    }

    @Override
    public <T> List<T> persist(T ... detachedObjects) {
        return this.persist(RCascadeType.PERSIST, detachedObjects);
    }

    @Override
    public <T> List<T> merge(T ... detachedObjects) {
        return this.persist(RCascadeType.MERGE, detachedObjects);
    }

    public <T> List<T> persist(RCascadeType type, T ... detachedObjects) {
        this.addExpireListener(this.commandExecutor);
        CommandBatchService batchService = new CommandBatchService(this.commandExecutor);
        HashMap classCache = new HashMap();
        LinkedHashMap<T, T> detached2Attached = new LinkedHashMap<T, T>();
        HashMap<String, Object> name2id = new HashMap<String, Object>();
        for (T detachedObject : detachedObjects) {
            Object id = this.getId(detachedObject);
            T attachedObject2 = this.attach(detachedObject, batchService, classCache);
            RMap<String, Object> liveMap = this.getMap(attachedObject2);
            detached2Attached.put(detachedObject, attachedObject2);
            name2id.put(liveMap.getName(), id);
        }
        if (type == RCascadeType.PERSIST) {
            CommandBatchService checkExecutor = new CommandBatchService(this.commandExecutor);
            for (Map.Entry entry : name2id.entrySet()) {
                RedissonMap map = new RedissonMap(checkExecutor, (String)entry.getKey(), null, null, null);
                map.containsKeyAsync("redisson_live_object");
            }
            BatchResult<?> batchResult = checkExecutor.execute();
            for (int i = 0; i < batchResult.getResponses().size(); ++i) {
                Boolean value = (Boolean)batchResult.getResponses().get(i);
                if (!value.booleanValue()) continue;
                ArrayList list = new ArrayList(name2id.values());
                Object id = list.get(i);
                throw new IllegalArgumentException("Object with id=" + id + " already exists.");
            }
        }
        for (Map.Entry entry : detached2Attached.entrySet()) {
            Object detachedObject = entry.getKey();
            Object attachedObject3 = entry.getValue();
            for (FieldDescription.InDefinedShape field : Introspectior.getAllFields(detachedObject.getClass())) {
                Object object = ClassUtils.getField(detachedObject, field.getName());
                if (object == null || object instanceof Collection || ClassUtils.isAnnotationPresent(object.getClass(), REntity.class)) continue;
                this.validateAnnotation(detachedObject, field.getName());
            }
            String idFieldName = this.getRIdFieldName(detachedObject.getClass());
            this.copy(detachedObject, attachedObject3, Arrays.asList(idFieldName));
        }
        ClassIntrospector.get().reset();
        batchService.execute();
        detached2Attached.values().forEach(attachedObject -> {
            RLiveObject lo = this.asLiveObject(attachedObject);
            this.mapResolver.remove(attachedObject.getClass().getSuperclass(), lo.getLiveObjectId());
        });
        classCache.clear();
        ArrayList attachedObjects = new ArrayList();
        for (Object attachedObject4 : detached2Attached.values()) {
            RLiveObject lo = this.asLiveObject(attachedObject4);
            Object nlo = this.createLiveObject(attachedObject4.getClass().getSuperclass(), lo.getLiveObjectId(), this.commandExecutor, classCache);
            attachedObjects.add(nlo);
        }
        return attachedObjects;
    }

    private <T> Object getId(T detachedObject) {
        String idFieldName = this.getRIdFieldName(detachedObject.getClass());
        Object id = ClassUtils.getField(detachedObject, idFieldName);
        if (id == null) {
            try {
                id = this.generateId(detachedObject.getClass(), idFieldName);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(e);
            }
            ClassUtils.setField(detachedObject, idFieldName, id);
        }
        return id;
    }

    private <T> T persist(T detachedObject, Map<Object, Object> alreadyPersisted, RCascadeType type) {
        this.addExpireListener(this.commandExecutor);
        this.validateDetached(detachedObject);
        Object id = this.getId(detachedObject);
        T attachedObject = this.attach(detachedObject);
        alreadyPersisted.put(detachedObject, attachedObject);
        RMap<String, Object> liveMap = this.getMap(attachedObject);
        ArrayList<String> excludedFields = new ArrayList<String>();
        String idFieldName = this.getRIdFieldName(detachedObject.getClass());
        excludedFields.add(idFieldName);
        boolean fastResult = liveMap.fastPut("redisson_live_object", "1");
        if (type == RCascadeType.PERSIST && !fastResult) {
            throw new IllegalArgumentException("This REntity already exists.");
        }
        for (FieldDescription.InDefinedShape field : Introspectior.getAllFields(detachedObject.getClass())) {
            Object object = ClassUtils.getField(detachedObject, field.getName());
            if (object == null) continue;
            RObject rObject = this.commandExecutor.getObjectBuilder().createObject(id, detachedObject.getClass(), object.getClass(), field.getName());
            if (rObject != null) {
                this.commandExecutor.getObjectBuilder().store(rObject, field.getName(), liveMap);
                if (rObject instanceof SortedSet) {
                    ((RSortedSet)rObject).trySetComparator(((SortedSet)object).comparator());
                }
                if (rObject instanceof Collection) {
                    Collection coll = (Collection)((Object)rObject);
                    if (type == RCascadeType.MERGE) {
                        coll.clear();
                    }
                    for (Object obj : (Collection)object) {
                        if (obj != null && ClassUtils.isAnnotationPresent(obj.getClass(), REntity.class)) {
                            Object persisted = alreadyPersisted.get(obj);
                            if (persisted == null && this.checkCascade(detachedObject, type, field.getName())) {
                                persisted = this.persist(obj, alreadyPersisted, type);
                            }
                            obj = persisted;
                        }
                        coll.add(obj);
                    }
                } else if (rObject instanceof Map) {
                    Map rMap = (Map)((Object)rObject);
                    if (type == RCascadeType.MERGE) {
                        rMap.clear();
                    }
                    Map map = (Map)object;
                    for (Map.Entry entry : map.entrySet()) {
                        Object persisted;
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (key != null && ClassUtils.isAnnotationPresent(key.getClass(), REntity.class)) {
                            persisted = alreadyPersisted.get(key);
                            if (persisted == null && this.checkCascade(detachedObject, type, field.getName())) {
                                persisted = this.persist(key, alreadyPersisted, type);
                            }
                            key = persisted;
                        }
                        if (value != null && ClassUtils.isAnnotationPresent(value.getClass(), REntity.class)) {
                            persisted = alreadyPersisted.get(value);
                            if (persisted == null && this.checkCascade(detachedObject, type, field.getName())) {
                                persisted = this.persist(value, alreadyPersisted, type);
                            }
                            value = persisted;
                        }
                        rMap.put(key, value);
                    }
                }
                excludedFields.add(field.getName());
                continue;
            }
            if (ClassUtils.isAnnotationPresent(object.getClass(), REntity.class)) {
                Object persisted = alreadyPersisted.get(object);
                if (persisted == null && this.checkCascade(detachedObject, type, field.getName())) {
                    persisted = this.persist(object, alreadyPersisted, type);
                }
                excludedFields.add(field.getName());
                BeanUtil.pojo.setSimpleProperty(attachedObject, field.getName(), persisted);
                continue;
            }
            this.validateAnnotation(detachedObject, field.getName());
        }
        this.copy(detachedObject, attachedObject, excludedFields);
        return attachedObject;
    }

    private void validateAnnotation(Object instance, String fieldName) {
        RCascade annotation;
        Class<?> clazz = instance.getClass();
        if (this.isLiveObject(instance)) {
            clazz = clazz.getSuperclass();
        }
        if ((annotation = ClassUtils.getAnnotation(clazz, fieldName, RCascade.class)) != null) {
            throw new IllegalArgumentException("RCascade annotation couldn't be defined for non-Redisson object '" + clazz + "' and field '" + fieldName + "'");
        }
    }

    private <T> boolean checkCascade(Object instance, RCascadeType type, String fieldName) {
        RCascade annotation;
        Class<?> clazz = instance.getClass();
        if (this.isLiveObject(instance)) {
            clazz = clazz.getSuperclass();
        }
        return (annotation = ClassUtils.getAnnotation(clazz, fieldName, RCascade.class)) != null && (Arrays.asList(annotation.value()).contains((Object)type) || Arrays.asList(annotation.value()).contains((Object)RCascadeType.ALL));
    }

    @Override
    public <T> T detach(T attachedObject) {
        this.addExpireListener(this.commandExecutor);
        HashMap<String, Object> alreadyDetached = new HashMap<String, Object>();
        return this.detach(attachedObject, alreadyDetached);
    }

    /*
     * WARNING - void declaration
     */
    private <T> T detach(T attachedObject, Map<String, Object> alreadyDetached) {
        this.validateAttached(attachedObject);
        Object detached = this.instantiateDetachedObject(attachedObject.getClass().getSuperclass(), this.asLiveObject(attachedObject).getLiveObjectId());
        new BeanCopy(attachedObject, detached).declared(true).copy();
        alreadyDetached.put(this.getMap(attachedObject).getName(), detached);
        for (Map.Entry<String, Object> obj : this.getMap(attachedObject).entrySet()) {
            Object detachedObject;
            if (!this.checkCascade(attachedObject, RCascadeType.DETACH, obj.getKey())) continue;
            if (obj.getValue() instanceof RSortedSet) {
                SortedSet redissonSet = (SortedSet)obj.getValue();
                TreeSet<void> set = new TreeSet<void>(redissonSet.comparator());
                for (Object e : redissonSet) {
                    void var9_12;
                    if (this.isLiveObject(e)) {
                        detachedObject = alreadyDetached.get(this.getMap(e).getName());
                        if (detachedObject == null) {
                            detachedObject = this.detach(e, alreadyDetached);
                        }
                        Object object = detachedObject;
                    }
                    set.add(var9_12);
                }
                ClassUtils.setField(detached, obj.getKey(), set);
                continue;
            }
            if (obj.getValue() instanceof RDeque) {
                Collection redissonDeque = (Collection)obj.getValue();
                LinkedList<void> deque = new LinkedList<void>();
                for (Object e : redissonDeque) {
                    void var9_15;
                    if (this.isLiveObject(e)) {
                        detachedObject = alreadyDetached.get(this.getMap(e).getName());
                        if (detachedObject == null) {
                            detachedObject = this.detach(e, alreadyDetached);
                        }
                        Object object = detachedObject;
                    }
                    deque.add(var9_15);
                }
                ClassUtils.setField(detached, obj.getKey(), deque);
                continue;
            }
            if (obj.getValue() instanceof RQueue) {
                Collection redissonQueue = (Collection)obj.getValue();
                LinkedList<void> queue = new LinkedList<void>();
                for (Object e : redissonQueue) {
                    void var9_18;
                    if (this.isLiveObject(e)) {
                        detachedObject = alreadyDetached.get(this.getMap(e).getName());
                        if (detachedObject == null) {
                            detachedObject = this.detach(e, alreadyDetached);
                        }
                        Object object = detachedObject;
                    }
                    queue.add(var9_18);
                }
                ClassUtils.setField(detached, obj.getKey(), queue);
                continue;
            }
            if (obj.getValue() instanceof RSet) {
                HashSet<void> set = new HashSet<void>();
                Collection redissonSet = (Collection)obj.getValue();
                for (Object e : redissonSet) {
                    void var9_21;
                    if (this.isLiveObject(e)) {
                        detachedObject = alreadyDetached.get(this.getMap(e).getName());
                        if (detachedObject == null) {
                            detachedObject = this.detach(e, alreadyDetached);
                        }
                        Object object = detachedObject;
                    }
                    set.add(var9_21);
                }
                ClassUtils.setField(detached, obj.getKey(), set);
                continue;
            }
            if (obj.getValue() instanceof RList) {
                ArrayList<void> list = new ArrayList<void>();
                Collection redissonList = (Collection)obj.getValue();
                for (Object e : redissonList) {
                    void var9_24;
                    if (this.isLiveObject(e)) {
                        detachedObject = alreadyDetached.get(this.getMap(e).getName());
                        if (detachedObject == null) {
                            detachedObject = this.detach(e, alreadyDetached);
                        }
                        Object object = detachedObject;
                    }
                    list.add(var9_24);
                }
                ClassUtils.setField(detached, obj.getKey(), list);
                continue;
            }
            if (this.isLiveObject(obj.getValue())) {
                Object detachedObject2 = alreadyDetached.get(this.getMap(obj.getValue()).getName());
                if (detachedObject2 == null) {
                    detachedObject2 = this.detach(obj.getValue(), alreadyDetached);
                }
                ClassUtils.setField(detached, obj.getKey(), detachedObject2);
                continue;
            }
            if (obj.getValue() instanceof RMap) {
                LinkedHashMap map = new LinkedHashMap();
                Map redissonMap = (Map)obj.getValue();
                for (Map.Entry entry : redissonMap.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (this.isLiveObject(key)) {
                        Object detachedObject3 = alreadyDetached.get(this.getMap(key).getName());
                        if (detachedObject3 == null) {
                            detachedObject3 = this.detach(key, alreadyDetached);
                        }
                        key = detachedObject3;
                    }
                    if (this.isLiveObject(value)) {
                        Object detachedObject2 = alreadyDetached.get(this.getMap(value).getName());
                        if (detachedObject2 == null) {
                            detachedObject2 = this.detach(value, alreadyDetached);
                        }
                        value = detachedObject2;
                    }
                    map.put(key, value);
                }
                ClassUtils.setField(detached, obj.getKey(), map);
                continue;
            }
            this.validateAnnotation(detached, obj.getKey());
        }
        return (T)detached;
    }

    @Override
    public <T> void delete(T attachedObject) {
        this.addExpireListener(this.commandExecutor);
        HashSet<String> deleted = new HashSet<String>();
        this.delete(attachedObject, deleted);
    }

    private <T> void delete(T attachedObject, Set<String> deleted) {
        this.validateAttached(attachedObject);
        for (Map.Entry<String, Object> obj : this.getMap(attachedObject).entrySet()) {
            if (!this.checkCascade(attachedObject, RCascadeType.DELETE, obj.getKey())) continue;
            if (obj.getValue() instanceof RSortedSet) {
                this.deleteCollection(deleted, (Iterable)obj.getValue());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            if (obj.getValue() instanceof RDeque) {
                this.deleteCollection(deleted, (Iterable)obj.getValue());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            if (obj.getValue() instanceof RQueue) {
                this.deleteCollection(deleted, (Iterable)obj.getValue());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            if (obj.getValue() instanceof RSet) {
                this.deleteCollection(deleted, (Iterable)obj.getValue());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            if (obj.getValue() instanceof RList) {
                this.deleteCollection(deleted, (Iterable)obj.getValue());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            if (this.isLiveObject(obj.getValue())) {
                if (!deleted.add(((RedissonObject)((Object)this.getMap(obj.getValue()))).getRawName())) continue;
                this.delete(obj.getValue(), deleted);
                continue;
            }
            if (obj.getValue() instanceof RMap) {
                RMap map = (RMap)obj.getValue();
                this.deleteCollection(deleted, map.keySet());
                this.deleteCollection(deleted, map.values());
                ((RObject)obj.getValue()).delete();
                continue;
            }
            this.validateAnnotation(attachedObject, obj.getKey());
        }
        this.asLiveObject(attachedObject).delete();
    }

    private void deleteCollection(Set<String> deleted, Iterable<?> objs) {
        for (Object object : objs) {
            if (!this.isLiveObject(object) || !deleted.add(((RedissonObject)((Object)this.getMap(object))).getRawName())) continue;
            this.delete(object, deleted);
        }
    }

    @Override
    public <T> long delete(Class<T> entityClass, Object ... ids) {
        this.addExpireListener(this.commandExecutor);
        CommandBatchService ce = new CommandBatchService(this.commandExecutor);
        FieldList<FieldDescription.InDefinedShape> fields = Introspectior.getFieldsWithAnnotation(entityClass, RIndex.class);
        Set<String> fieldNames = fields.stream().map(f -> f.getName()).collect(Collectors.toSet());
        NamingScheme namingScheme = this.commandExecutor.getObjectBuilder().getNamingScheme(entityClass);
        for (Object id : ids) {
            this.delete(id, entityClass, namingScheme, ce, fieldNames);
        }
        BatchResult<?> r = ce.execute();
        return r.getResponses().stream().filter(s -> s instanceof Long).mapToLong(s -> (Long)s).sum();
    }

    private RFuture<Long> delete(Object id, Class<?> entityClass, NamingScheme namingScheme, CommandBatchService ce, Set<String> fieldNames) {
        String mapName = namingScheme.getName(entityClass, id);
        Object liveObjectId = namingScheme.resolveId(mapName);
        this.deleteCollections(id, entityClass, ce);
        RedissonMap liveMap = new RedissonMap(namingScheme.getCodec(), this.commandExecutor, mapName, null, null, null);
        Map values = liveMap.getAll(fieldNames);
        for (String fieldName : fieldNames) {
            Object value = values.get(fieldName);
            if (value == null) continue;
            String indexName = namingScheme.getIndexName(entityClass, fieldName);
            if (value instanceof Number) {
                RedissonScoredSortedSet<Object> set = new RedissonScoredSortedSet<Object>(namingScheme.getCodec(), ce, indexName, null);
                set.removeAsync(liveObjectId);
                continue;
            }
            RedissonSetMultimap idsMultimap = new RedissonSetMultimap(namingScheme.getCodec(), ce, indexName);
            idsMultimap.removeAsync(value, liveObjectId);
        }
        this.mapResolver.remove(entityClass, id);
        return new RedissonKeys(ce).deleteAsync(mapName);
    }

    private void deleteExpired(Object id, Class<?> entityClass) {
        CommandBatchService ce = new CommandBatchService(this.commandExecutor);
        FieldList<FieldDescription.InDefinedShape> fields = Introspectior.getFieldsWithAnnotation(entityClass, RIndex.class);
        this.deleteCollections(id, entityClass, ce);
        NamingScheme namingScheme = this.commandExecutor.getObjectBuilder().getNamingScheme(entityClass);
        String mapName = namingScheme.getName(entityClass, id);
        Object liveObjectId = namingScheme.resolveId(mapName);
        TypeDescription.Generic n1 = TypeDescription.Generic.Builder.rawType(Number.class).build();
        for (FieldDescription.InDefinedShape field : fields) {
            boolean isNumber = ((TypeDescription.Generic.Visitor.Assigner.Dispatcher)n1.accept((TypeDescription.Generic.Visitor)TypeDescription.Generic.Visitor.Assigner.INSTANCE)).isAssignableFrom(field.getType().asErasure().asBoxed().asGenericType());
            String indexName = namingScheme.getIndexName(entityClass, field.getName());
            if (isNumber) {
                RedissonScoredSortedSet<Object> set = new RedissonScoredSortedSet<Object>(namingScheme.getCodec(), ce, indexName, null);
                set.removeAsync(liveObjectId);
                continue;
            }
            RedissonSetMultimap idsMultimap = new RedissonSetMultimap(namingScheme.getCodec(), ce, indexName);
            idsMultimap.fastRemoveValueAsync(liveObjectId);
        }
        ce.execute();
    }

    private void deleteCollections(Object id, Class<?> entityClass, CommandBatchService ce) {
        for (FieldDescription.InDefinedShape field : Introspectior.getAllFields(entityClass)) {
            try {
                Field f = ClassUtils.getDeclaredField(entityClass, field.getName());
                RObject rObject = this.commandExecutor.getObjectBuilder().createObject(id, entityClass, f.getType(), field.getName());
                if (rObject == null) continue;
                RedissonObject ro = (RedissonObject)rObject;
                ce.writeAsync(ro.getRawName(), RedisCommands.DEL, ro.getRawName());
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public RFuture<Long> delete(Object id, Class<?> entityClass, NamingScheme namingScheme, CommandBatchService ce) {
        FieldList<FieldDescription.InDefinedShape> fields = Introspectior.getFieldsWithAnnotation(entityClass, RIndex.class);
        Set<String> fieldNames = fields.stream().map(f -> f.getName()).collect(Collectors.toSet());
        return this.delete(id, entityClass, namingScheme, ce, fieldNames);
    }

    @Override
    public <K> Iterable<K> findIds(Class<?> entityClass) {
        return this.findIds(entityClass, 10);
    }

    @Override
    public <K> Iterable<K> findIds(Class<?> entityClass, int count) {
        this.addExpireListener(this.commandExecutor);
        final NamingScheme namingScheme = this.commandExecutor.getObjectBuilder().getNamingScheme(entityClass);
        String pattern = namingScheme.getNamePattern(entityClass);
        RedissonKeys keys = new RedissonKeys(this.commandExecutor);
        RedisCommand<Object> command = new RedisCommand<Object>("SCAN", new ListMultiDecoder2(new ListScanResultReplayDecoder(), new ObjectListReplayDecoder()), new Convertor<Object>(){
            int index;

            @Override
            public Object convert(Object obj) {
                ++this.index;
                if (this.index == 1) {
                    return obj;
                }
                return namingScheme.resolveId(obj.toString());
            }
        });
        return keys.getKeysByPattern(command, pattern, 0, count, null);
    }

    @Override
    public <T> RLiveObject asLiveObject(T instance) {
        return (RLiveObject)instance;
    }

    @Override
    public <T, K, V> RMap<K, V> asRMap(T instance) {
        return (RMap)instance;
    }

    @Override
    public <T> boolean isLiveObject(T instance) {
        return instance instanceof RLiveObject;
    }

    @Override
    public <T> boolean isExists(T instance) {
        this.addExpireListener(this.commandExecutor);
        return instance instanceof RLiveObject && this.asLiveObject(instance).isExists();
    }

    @Override
    public void registerClass(Class<?> cls) {
        if (!this.classCache.containsKey(cls)) {
            this.validateClass(cls);
            Class<?> proxyClass = this.createProxy(cls, this.commandExecutor);
            this.classCache.putIfAbsent(cls, proxyClass);
        }
    }

    @Override
    public void unregisterClass(Class<?> cls) {
        if (cls.isAssignableFrom(RLiveObject.class)) {
            this.classCache.remove(cls.getSuperclass());
            this.mapResolver.remove(cls.getSuperclass());
        } else {
            this.classCache.remove(cls);
            this.mapResolver.remove(cls);
        }
    }

    @Override
    public boolean isClassRegistered(Class<?> cls) {
        return this.classCache.containsKey(cls) || this.classCache.containsValue(cls);
    }

    private <T> void copy(T detachedObject, T attachedObject, List<String> excludedFields) {
        new AdvBeanCopy(detachedObject, attachedObject).copy(excludedFields);
    }

    private String getRIdFieldName(Class<?> cls) {
        return Introspectior.getREntityIdFieldName(cls);
    }

    private <T> T instantiateLiveObject(Class<T> proxyClass, Object id) {
        if (id == null) {
            throw new IllegalStateException("Non-null value is required for the field with RId annotation.");
        }
        T instance = this.instantiate(proxyClass);
        this.asLiveObject(instance).setLiveObjectId(id);
        return instance;
    }

    private <T, K> T instantiateDetachedObject(Class<T> cls, K id) {
        String fieldName;
        T instance = this.instantiate(cls);
        if (ClassUtils.getField(instance, fieldName = this.getRIdFieldName(cls)) == null) {
            ClassUtils.setField(instance, fieldName, id);
        }
        return instance;
    }

    private <T> T instantiate(Class<T> cls) {
        try {
            for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                constructor.setAccessible(true);
                return (T)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException("Can't find default constructor for " + cls);
    }

    private <T> void validateClass(Class<T> entityClass) {
        if (entityClass.isAnonymousClass() || entityClass.isLocalClass()) {
            throw new IllegalArgumentException(entityClass.getName() + " is not publically accessable.");
        }
        if (!ClassUtils.isAnnotationPresent(entityClass, REntity.class)) {
            throw new IllegalArgumentException("REntity annotation is missing from class type declaration.");
        }
        FieldList fields = Introspectior.getFieldsWithAnnotation(entityClass, RIndex.class);
        Iterator iterator = (fields = (FieldList)fields.filter((ElementMatcher)ElementMatchers.fieldType((ElementMatcher)ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.anyOf((Type[])new Type[]{Map.class, Collection.class, RObject.class}))))).iterator();
        if (iterator.hasNext()) {
            FieldDescription.InDefinedShape field = (FieldDescription.InDefinedShape)iterator.next();
            throw new IllegalArgumentException("RIndex annotation couldn't be defined for field '" + field.getName() + "' with type '" + field.getType() + "'");
        }
        FieldList<FieldDescription.InDefinedShape> fieldsWithRIdAnnotation = Introspectior.getFieldsWithAnnotation(entityClass, RId.class);
        if (fieldsWithRIdAnnotation.size() == 0) {
            throw new IllegalArgumentException("RId annotation is missing from class field declaration.");
        }
        if (fieldsWithRIdAnnotation.size() > 1) {
            throw new IllegalArgumentException("Only one field with RId annotation is allowed in class field declaration.");
        }
        FieldDescription.InDefinedShape idFieldDescription = (FieldDescription.InDefinedShape)fieldsWithRIdAnnotation.getOnly();
        String idFieldName = idFieldDescription.getName();
        Field idField = null;
        try {
            idField = ClassUtils.getDeclaredField(entityClass, idFieldName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (ClassUtils.isAnnotationPresent(idField.getType(), REntity.class)) {
            throw new IllegalArgumentException("Field with RId annotation cannot be a type of which class is annotated with REntity.");
        }
        if (idField.getType().isAssignableFrom(RObject.class)) {
            throw new IllegalArgumentException("Field with RId annotation cannot be a type of RObject");
        }
    }

    private <T> void validateDetached(T detachedObject) {
        if (detachedObject instanceof RLiveObject) {
            throw new IllegalArgumentException("The object supplied is already a RLiveObject");
        }
    }

    private <T> void validateAttached(T attachedObject) {
        if (!(attachedObject instanceof RLiveObject)) {
            throw new IllegalArgumentException("The object supplied is must be a RLiveObject");
        }
    }

    private <T> Class<? extends T> createProxy(Class<T> entityClass, CommandAsyncExecutor commandExecutor) {
        DynamicType.Builder builder = new ByteBuddy().subclass(entityClass);
        for (FieldDescription.InDefinedShape field : Introspectior.getTypeDescription(LiveObjectTemplate.class).getDeclaredFields()) {
            builder = builder.define((FieldDescription)field);
        }
        Class proxied = builder.method((ElementMatcher)ElementMatchers.isDeclaredBy((ElementMatcher)ElementMatchers.anyOf((Type[])new Type[]{RLiveObject.class, RExpirable.class, RObject.class})).and((ElementMatcher)ElementMatchers.isGetter().or((ElementMatcher)ElementMatchers.isSetter()).or((ElementMatcher)ElementMatchers.named((String)"isPhantom")).or((ElementMatcher)ElementMatchers.named((String)"delete")))).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{FieldProxy.Binder.install(LiveObjectInterceptor.Getter.class, LiveObjectInterceptor.Setter.class)}).to((Object)new LiveObjectInterceptor(commandExecutor, this, entityClass, this.mapResolver))).implement(new Type[]{RLiveObject.class}).method((ElementMatcher)ElementMatchers.isAnnotatedWith(RFieldAccessor.class).and((ElementMatcher)ElementMatchers.named((String)"get").or((ElementMatcher)ElementMatchers.named((String)"set")))).intercept((Implementation)MethodDelegation.to(FieldAccessorInterceptor.class)).method((ElementMatcher)ElementMatchers.isDeclaredBy(Map.class).or((ElementMatcher)ElementMatchers.isDeclaredBy(RExpirable.class)).or((ElementMatcher)ElementMatchers.isDeclaredBy(RExpirableAsync.class)).or((ElementMatcher)ElementMatchers.isDeclaredBy(ConcurrentMap.class)).or((ElementMatcher)ElementMatchers.isDeclaredBy(RMapAsync.class)).or((ElementMatcher)ElementMatchers.isDeclaredBy(RMap.class))).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{FieldProxy.Binder.install(LiveObjectInterceptor.Getter.class, LiveObjectInterceptor.Setter.class)}).to((Object)new RMapInterceptor(commandExecutor, entityClass, this.mapResolver))).implement(new Type[]{RMap.class}).method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class)).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(RLiveObject.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(RExpirable.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(RExpirableAsync.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(RObject.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(RObjectAsync.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(ConcurrentMap.class))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Map.class))).and((ElementMatcher)ElementMatchers.isGetter().or((ElementMatcher)ElementMatchers.isSetter())).and((ElementMatcher)ElementMatchers.isPublic().or((ElementMatcher)ElementMatchers.isProtected()))).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{FieldProxy.Binder.install(LiveObjectInterceptor.Getter.class, LiveObjectInterceptor.Setter.class)}).to((Object)new AccessorInterceptor(entityClass, commandExecutor, this.mapResolver))).make().load(entityClass.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
        return proxied;
    }
}

