/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionsHolder;
import org.redisson.misc.AsyncSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleConnectionWatcher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<ClientConnectionsEntry, List<Entry>> entries = new ConcurrentHashMap<ClientConnectionsEntry, List<Entry>>();
    private final ScheduledFuture<?> monitorFuture;

    public IdleConnectionWatcher(EventLoopGroup group, MasterSlaveServersConfig config) {
        this.monitorFuture = group.scheduleWithFixedDelay(() -> {
            long currTime = System.nanoTime();
            for (Entry entry : this.entries.values().stream().flatMap(m -> m.stream()).collect(Collectors.toList())) {
                if (!this.validateAmount(entry)) continue;
                for (RedisConnection c : entry.connections) {
                    long timeInPool = TimeUnit.NANOSECONDS.toMillis(currTime - c.getLastUsageTime());
                    if (c instanceof RedisPubSubConnection && (!((RedisPubSubConnection)c).getChannels().isEmpty() || !((RedisPubSubConnection)c).getPatternChannels().isEmpty() || !((RedisPubSubConnection)c).getShardedChannels().isEmpty()) || timeInPool <= (long)config.getIdleConnectionTimeout() || !this.validateAmount(entry) || !entry.holder.remove(c)) continue;
                    ChannelFuture future = c.closeIdleAsync();
                    future.addListener((GenericFutureListener)((FutureListener)f -> this.log.debug("Connection {} has been closed due to idle timeout. Not used for {} ms", (Object)c.getChannel(), (Object)timeInPool)));
                }
            }
        }, (long)config.getIdleConnectionTimeout(), (long)config.getIdleConnectionTimeout(), TimeUnit.MILLISECONDS);
    }

    private boolean validateAmount(Entry entry) {
        return entry.maximumAmount - entry.freeConnectionsCounter.getCounter() + entry.connections.size() > entry.minimumAmount;
    }

    public void remove(ClientConnectionsEntry entry) {
        this.entries.remove(entry);
    }

    public void add(ClientConnectionsEntry entry, int minimumAmount, int maximumAmount, ConnectionsHolder<? extends RedisConnection> holder) {
        List list = this.entries.computeIfAbsent(entry, k -> new ArrayList(2));
        list.add(new Entry(minimumAmount, maximumAmount, holder));
    }

    public void stop() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
    }

    public static class Entry {
        private final int minimumAmount;
        private final int maximumAmount;
        private final ConnectionsHolder<? extends RedisConnection> holder;
        private final AsyncSemaphore freeConnectionsCounter;
        private final Collection<? extends RedisConnection> connections;

        public Entry(int minimumAmount, int maximumAmount, ConnectionsHolder<? extends RedisConnection> holder) {
            this.minimumAmount = minimumAmount;
            this.maximumAmount = maximumAmount;
            this.connections = holder.getFreeConnections();
            this.freeConnectionsCounter = holder.getFreeConnectionsCounter();
            this.holder = holder;
        }
    }
}

