/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.ClassBasedMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.ClassInternalNameMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import java.util.Objects;

@InterfaceStability.Unstable
public class DefaultClassBasedMatcher
implements ClassBasedMatcher {
    private final String baseClassName;
    private final MatcherOperand matcherOperand;

    DefaultClassBasedMatcher(String baseClassName) {
        this(baseClassName, null);
    }

    DefaultClassBasedMatcher(String baseClassName, MatcherOperand additional) {
        this.baseClassName = Objects.requireNonNull(baseClassName, "baseClassName");
        this.matcherOperand = this.getMatcherOperand(baseClassName, additional);
    }

    private MatcherOperand getMatcherOperand(String baseClassName, MatcherOperand additional) {
        MatcherOperand operand = new ClassInternalNameMatcherOperand(baseClassName);
        if (additional != null) {
            operand = operand.and(additional);
        }
        return operand;
    }

    @Override
    public String getBaseClassName() {
        return this.baseClassName;
    }

    @Override
    public MatcherOperand getMatcherOperand() {
        return this.matcherOperand;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultClassBasedMatcher{");
        sb.append("baseClassName='").append(this.baseClassName).append('\'');
        sb.append(", matcherOperand=").append(this.matcherOperand);
        sb.append('}');
        return sb.toString();
    }
}

