/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AbstractAsyncContextSpanEventEndPointInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.util.ScopeUtils;
import java.util.Objects;

public abstract class AsyncContextSpanEventEndPointInterceptor
extends AbstractAsyncContextSpanEventEndPointInterceptor
implements AroundInterceptor {
    protected final MethodDescriptor methodDescriptor;

    public AsyncContextSpanEventEndPointInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        super(traceContext);
        this.methodDescriptor = Objects.requireNonNull(methodDescriptor, "methodDescriptor");
    }

    @Override
    public void before(Object target, Object[] args) {
        block6: {
            AsyncContext asyncContext;
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if ((asyncContext = this.getAsyncContext(target, args)) == null) {
                return;
            }
            Trace trace = this.getAsyncTrace(asyncContext);
            if (trace == null) {
                return;
            }
            if (this.isDebug) {
                this.logger.debug("Asynchronous invocation. asyncContext={}, trace={}", (Object)asyncContext, (Object)trace);
            }
            ScopeUtils.entryAsyncTraceScope(trace);
            try {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                this.beforeTrace(asyncContext, trace, recorder, target, args);
                this.doInBeforeTrace(recorder, target, args);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block6;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    protected void beforeTrace(AsyncContext asyncContext, Trace trace, SpanEventRecorder recorder, Object target, Object[] args) {
    }

    protected abstract void doInBeforeTrace(SpanEventRecorder var1, Object var2, Object[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        AsyncContext asyncContext;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((asyncContext = this.getAsyncContext(target, args, result, throwable)) == null) {
            return;
        }
        Trace trace = asyncContext.currentAsyncTraceObject();
        if (trace == null) {
            return;
        }
        if (this.isDebug) {
            this.logger.debug("Asynchronous invocation. asyncContext={}, trace={}", (Object)asyncContext, (Object)trace);
        }
        if (!ScopeUtils.leaveAsyncTraceScope(trace)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Failed to leave scope of async trace {}.", (Object)trace);
            }
            this.deleteAsyncTrace(trace);
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            this.afterTrace(asyncContext, trace, recorder, target, args, result, throwable);
            this.doInAfterTrace(recorder, target, args, result, throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER error. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
            if (ScopeUtils.isAsyncTraceEndScope(trace)) {
                this.deleteAsyncTrace(trace);
            }
            this.finishAsyncState(asyncContext);
        }
    }

    protected void afterTrace(AsyncContext asyncContext, Trace trace, SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
    }

    protected abstract void doInAfterTrace(SpanEventRecorder var1, Object var2, Object[] var3, Object var4, Throwable var5);
}

