/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServerHeaderRecorder;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.DataType;
import com.navercorp.pinpoint.common.util.StringStringValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AllServerHeaderRecorder<REQ>
implements ServerHeaderRecorder<REQ> {
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    public static final String HEADERS_ALL = "HEADERS-ALL";
    private final RequestAdaptor<REQ> requestAdaptor;

    public AllServerHeaderRecorder(RequestAdaptor<REQ> requestAdaptor) {
        this.requestAdaptor = Objects.requireNonNull(requestAdaptor, "requestAdaptor");
    }

    public static boolean isRecordAllHeaders(List<String> recordHeaders) {
        return recordHeaders.contains(HEADERS_ALL);
    }

    @Override
    public void recordHeader(SpanRecorder recorder, REQ request) {
        Collection<String> headerNames = this.getHeaderNames(request);
        for (String headerName : headerNames) {
            String value = this.requestAdaptor.getHeader(request, headerName);
            if (value == null) continue;
            StringStringValue header = new StringStringValue(headerName, value);
            recorder.recordAttribute(AnnotationKey.HTTP_REQUEST_HEADER, (DataType)header);
        }
    }

    private Collection<String> getHeaderNames(REQ request) {
        try {
            return this.requestAdaptor.getHeaderNames(request);
        }
        catch (Exception e) {
            this.logger.warn("Extract all of the request header names from request {} failed, caused by:", (Object)request, (Object)e);
            return Collections.emptyList();
        }
    }
}

