/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.response;

import com.navercorp.pinpoint.bootstrap.context.AttributeRecorder;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.plugin.response.ResponseAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.response.ServerResponseHeaderRecorder;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.DataType;
import com.navercorp.pinpoint.common.util.StringStringValue;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class DefaultServerResponseHeaderRecorder<RESP>
implements ServerResponseHeaderRecorder<RESP> {
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private final ResponseAdaptor<RESP> responseAdaptor;
    private final String[] recordHeaders;

    public DefaultServerResponseHeaderRecorder(ResponseAdaptor<RESP> responseAdaptor, List<String> recordHeaders) {
        this.responseAdaptor = Objects.requireNonNull(responseAdaptor, "responseAdaptor");
        this.recordHeaders = recordHeaders.toArray(new String[0]);
    }

    @Override
    public void recordHeader(AttributeRecorder recorder, RESP response) {
        for (String headerName : this.recordHeaders) {
            Collection<String> headers;
            if (StringUtils.isEmpty((String)headerName) || CollectionUtils.isEmpty(headers = this.responseAdaptor.getHeaders(response, headerName))) continue;
            StringStringValue header = new StringStringValue(headerName, this.formatHeaderValues(headers));
            recorder.recordAttribute(AnnotationKey.HTTP_RESPONSE_HEADER, (DataType)header);
        }
    }

    private String formatHeaderValues(Collection<String> headers) {
        if (headers.size() == 1) {
            return headers.iterator().next();
        }
        return headers.toString();
    }
}

