/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.resolver.condition;

import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.resolver.condition.Condition;
import com.navercorp.pinpoint.bootstrap.resolver.condition.ConditionValue;
import com.navercorp.pinpoint.common.util.SimpleProperty;
import com.navercorp.pinpoint.common.util.SystemProperty;
import com.navercorp.pinpoint.common.util.SystemPropertyKey;
import java.io.IOException;
import java.util.jar.JarFile;

public class MainClassCondition
implements Condition<String>,
ConditionValue<String> {
    public static final MainClassCondition INSTANCE = new MainClassCondition();
    private static final String MANIFEST_MAIN_CLASS_KEY = "Main-Class";
    private static final String NOT_FOUND = null;
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass().getName());
    private final String applicationMainClassName;

    public MainClassCondition() {
        this((SimpleProperty)SystemProperty.INSTANCE);
    }

    public MainClassCondition(SimpleProperty property) {
        if (property == null) {
            throw new IllegalArgumentException("properties should not be null");
        }
        this.applicationMainClassName = this.getMainClassName(property);
        if (this.applicationMainClassName == NOT_FOUND) {
            this.logger.info("Main class could not be deduced, please set 'profiler.applicationservertype' in pinpoint.config.");
            this.logger.info("If you're running on 1.6.0_24 or prior version of Java, consider upgrading to 1.6.0_25+.");
        }
    }

    @Override
    public boolean check(String condition) {
        if (this.applicationMainClassName == NOT_FOUND) {
            return false;
        }
        if (this.applicationMainClassName.equals(condition)) {
            this.logger.debug("Main class match - [{}]", (Object)this.applicationMainClassName, (Object)condition);
            return true;
        }
        this.logger.debug("Main class does not match - found : [{}], expected : [{}]", (Object)this.applicationMainClassName, (Object)condition);
        return false;
    }

    @Override
    public String getValue() {
        if (this.applicationMainClassName == NOT_FOUND) {
            return "";
        }
        return this.applicationMainClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMainClassName(SimpleProperty property) {
        String javaCommand = property.getProperty(SystemPropertyKey.SUN_JAVA_COMMAND.getKey(), "").split(" ")[0];
        if (javaCommand.isEmpty()) {
            String jreVersion = property.getProperty(SystemPropertyKey.JAVA_RUNTIME_VERSION.getKey());
            this.logger.warn("Error retrieving main class using '{}', jre : {}", (Object)SystemPropertyKey.SUN_JAVA_COMMAND.getKey(), (Object)jreVersion);
            return NOT_FOUND;
        }
        JarFile executableArchive = null;
        try {
            executableArchive = new JarFile(javaCommand);
            String string = this.extractMainClassFromArchive(executableArchive);
            return string;
        }
        catch (IOException e) {
            String string = javaCommand;
            return string;
        }
        catch (Exception e) {
            this.logger.warn("Error retrieving main class", e);
            String string = NOT_FOUND;
            return string;
        }
        finally {
            if (executableArchive != null) {
                try {
                    executableArchive.close();
                }
                catch (IOException e) {
                    this.logger.warn("Error closing jarFile : [{}]", (Object)executableArchive.getName(), (Object)e);
                }
            }
        }
    }

    private String extractMainClassFromArchive(JarFile bootstrapJar) throws IOException {
        String mainClassFromManifest = bootstrapJar.getManifest().getMainAttributes().getValue(MANIFEST_MAIN_CLASS_KEY);
        if (mainClassFromManifest == null) {
            return NOT_FOUND;
        }
        return mainClassFromManifest;
    }
}

