/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.connection.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.OptionalLong;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcConfig;
import org.apache.eventmesh.connector.jdbc.connection.JdbcConnection;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlDialectSql;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.utils.MysqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlJdbcConnection
extends JdbcConnection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MysqlJdbcConnection.class);
    private static final int DEFAULT_CONNECT_TIMEOUT_SECOND = 10;
    public static final String URL_WITH_PLACEHOLDER = "jdbc:mysql://%s:%s/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=%s";

    public MysqlJdbcConnection(JdbcConfig jdbcConfig, JdbcConnection.InitialOperation initialOperation, JdbcConnection.ConnectionFactory connectionFactory) {
        super(jdbcConfig, initialOperation, connectionFactory);
    }

    public MysqlJdbcConnection(JdbcConfig jdbcConfig, JdbcConnection.InitialOperation initialOperation, JdbcConnection.ConnectionFactory connectionFactory, boolean lazyConnection) {
        super(jdbcConfig, initialOperation, connectionFactory, lazyConnection);
    }

    public MysqlJdbcConnection(JdbcConfig jdbcConfig, JdbcConnection.InitialOperation initialOperation) {
        super(jdbcConfig, initialOperation, MysqlJdbcConnection.getPatternConnectionFactory(jdbcConfig));
    }

    public MysqlJdbcConnection(JdbcConfig jdbcConfig, JdbcConnection.InitialOperation initialOperation, boolean lazyConnection) {
        super(jdbcConfig, initialOperation, MysqlJdbcConnection.getPatternConnectionFactory(jdbcConfig), lazyConnection);
    }

    private static JdbcConnection.ConnectionFactory getPatternConnectionFactory(JdbcConfig jdbcConfig) {
        return JdbcConnection.createPatternConnectionFactory(URL_WITH_PLACEHOLDER, jdbcConfig.getHostname(), String.valueOf(jdbcConfig.getPort()), String.valueOf(jdbcConfig.getConnectTimeout() <= 0 ? 10 : jdbcConfig.getConnectTimeout()));
    }

    public boolean enableGTID() {
        boolean enableGTID = false;
        try {
            enableGTID = this.query(MysqlDialectSql.SHOW_GTID_STATUS.ofSQL(), new JdbcConnection.ResultSetMapper<Boolean>(){

                @Override
                public Boolean map(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        if (!"ON".equalsIgnoreCase(rs.getString(2))) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (SQLException e) {
            log.error("Get executed gtid error", (Throwable)e);
        }
        return enableGTID;
    }

    public String executedGTID() {
        try {
            return this.query(MysqlDialectSql.SHOW_MASTER_STATUS.ofSQL(), new JdbcConnection.ResultSetMapper<String>(){

                @Override
                public String map(ResultSet rs) throws SQLException {
                    if (rs.next() && rs.getMetaData().getColumnCount() > 4) {
                        return rs.getString(5);
                    }
                    return "";
                }
            });
        }
        catch (SQLException e) {
            log.error("Get executed gtid error", (Throwable)e);
            return "";
        }
    }

    public String purgedGTID() {
        try {
            return this.query(MysqlDialectSql.SELECT_PURGED_GTID.ofSQL(), new JdbcConnection.ResultSetMapper<String>(){

                @Override
                public String map(ResultSet rs) throws SQLException {
                    if (rs.next() && rs.getMetaData().getColumnCount() > 4) {
                        return rs.getString(1);
                    }
                    return "";
                }
            });
        }
        catch (SQLException e) {
            log.error("Get executed gtid error", (Throwable)e);
            return "";
        }
    }

    public OptionalLong getRowCount4Table(TableId tableId) {
        try {
            this.execute(MysqlDialectSql.SELECT_DATABASE.ofWrapperSQL(MysqlUtils.wrapper(tableId.getCatalogName())));
            return this.query(MysqlDialectSql.SHOW_TABLE_STATUS.ofWrapperSQL(tableId.getTableName()), (ResultSet rs) -> {
                if (rs.next()) {
                    return OptionalLong.of(rs.getLong(5));
                }
                return OptionalLong.empty();
            });
        }
        catch (SQLException e) {
            log.error("Error get number of rows in table {} : {}", (Object)tableId, (Object)e.getMessage());
            return OptionalLong.empty();
        }
    }
}

