/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.listener;

import org.apache.eventmesh.common.config.connector.rdb.jdbc.SourceConnectorConfig;
import org.apache.eventmesh.connector.jdbc.CatalogChanges;
import org.apache.eventmesh.connector.jdbc.Payload;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParser;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParserBaseListener;
import org.apache.eventmesh.connector.jdbc.event.DropDatabaseEvent;
import org.apache.eventmesh.connector.jdbc.event.SchemaChangeEventType;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.MysqlAntlr4DdlParser;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlSourceMateData;
import org.apache.eventmesh.connector.jdbc.table.catalog.CatalogSchema;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.utils.Antlr4Utils;
import org.apache.eventmesh.connector.jdbc.utils.JdbcStringUtils;

public class DropDatabaseParserListener
extends MySqlParserBaseListener {
    private MysqlAntlr4DdlParser parser;

    public DropDatabaseParserListener(MysqlAntlr4DdlParser parser) {
        this.parser = parser;
    }

    @Override
    public void enterDropDatabase(MySqlParser.DropDatabaseContext ctx) {
        String databaseName = JdbcStringUtils.withoutWrapper(ctx.uid().getText());
        this.parser.getCatalogTableSet().removeDatabase(databaseName);
        if (this.parser.getCallback() != null) {
            String sql = Antlr4Utils.getText(ctx);
            CatalogSchema catalogSchema = new CatalogSchema(databaseName);
            DropDatabaseEvent event = new DropDatabaseEvent(new TableId(databaseName));
            Payload payload = event.getJdbcConnectData().getPayload();
            SourceConnectorConfig sourceConnectorConfig = this.parser.getSourceConfig().getSourceConnectorConfig();
            MysqlSourceMateData sourceMateData = MysqlSourceMateData.newBuilder().name(sourceConnectorConfig.getName()).catalogName(databaseName).serverId(sourceConnectorConfig.getMysqlConfig().getServerId()).build();
            CatalogChanges changes = CatalogChanges.newBuilder().operationType(SchemaChangeEventType.DATABASE_DROP).catalog(catalogSchema).build();
            payload.withSource(sourceMateData).withDdl(sql).withCatalogChanges(changes);
            this.parser.getCallback().handle(event);
        }
        super.enterDropDatabase(ctx);
    }
}

